/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation;

import cn.taketoday.lang.Assert;
import cn.taketoday.validation.Errors;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public interface Validator {
    public boolean supports(Class<?> var1);

    public void validate(Object var1, Errors var2);

    public static <T> Validator forInstanceOf(Class<T> targetClass, BiConsumer<T, Errors> delegate) {
        return new TypedValidator<T>(targetClass, targetClass::isAssignableFrom, delegate);
    }

    public static <T> Validator forType(Class<T> targetClass, BiConsumer<T, Errors> delegate) {
        return new TypedValidator<T>(targetClass, targetClass::equals, delegate);
    }

    public static final class TypedValidator<T>
    implements Validator {
        private final Class<T> targetClass;
        private final Predicate<Class<?>> supports;
        private final BiConsumer<T, Errors> validate;

        public TypedValidator(Class<T> targetClass, Predicate<Class<?>> supports, BiConsumer<T, Errors> validate) {
            Assert.notNull(targetClass, (String)"TargetClass is required");
            Assert.notNull(supports, (String)"Supports function is required");
            Assert.notNull(validate, (String)"Validate function is required");
            this.targetClass = targetClass;
            this.supports = supports;
            this.validate = validate;
        }

        @Override
        public boolean supports(Class<?> clazz) {
            return this.supports.test(clazz);
        }

        @Override
        public void validate(Object target, Errors errors) {
            this.validate.accept(this.targetClass.cast(target), errors);
        }
    }
}

