/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import cn.taketoday.validation.Errors;
import cn.taketoday.validation.SmartValidator;
import cn.taketoday.validation.Validator;

public abstract class ValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtils.class);

    public static void invokeValidator(Validator validator, Object target, Errors errors) {
        ValidationUtils.invokeValidator(validator, target, errors, null);
    }

    public static void invokeValidator(Validator validator, Object target, Errors errors, Object ... validationHints) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking validator [{}]", (Object)validator);
        }
        if (!validator.supports(target.getClass())) {
            throw new IllegalArgumentException("Validator [" + validator.getClass() + "] does not support [" + target.getClass() + "]");
        }
        if (ObjectUtils.isNotEmpty((Object[])validationHints) && validator instanceof SmartValidator) {
            ((SmartValidator)validator).validate(target, errors, validationHints);
        } else {
            validator.validate(target, errors);
        }
        if (logger.isDebugEnabled()) {
            if (errors.hasErrors()) {
                logger.debug("Validator found {} errors", (Object)errors.getErrorCount());
            } else {
                logger.debug("Validator found no errors");
            }
        }
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, null, null);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, Object[] errorArgs) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, errorArgs, null);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object value = errors.getFieldValue(field);
        if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
            errors.rejectValue(field, errorCode, errorArgs, defaultMessage);
        }
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, @Nullable Object[] errorArgs) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, errorArgs, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object value = errors.getFieldValue(field);
        if (value == null || StringUtils.isBlank((String)value.toString())) {
            errors.rejectValue(field, errorCode, errorArgs, defaultMessage);
        }
    }
}

