/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.BeansException;
import cn.taketoday.context.MessageSource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.validation.MessageSourceMessageInterpolator;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;

public class MessageInterpolatorFactory
implements Supplier<MessageInterpolator> {
    private static final Set<String> FALLBACKS;
    @Nullable
    private final MessageSource messageSource;

    public MessageInterpolatorFactory() {
        this(null);
    }

    public MessageInterpolatorFactory(@Nullable MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public MessageInterpolator get() throws BeansException {
        MessageInterpolator messageInterpolator = this.getMessageInterpolator();
        if (this.messageSource != null) {
            return new MessageSourceMessageInterpolator(this.messageSource, messageInterpolator);
        }
        return messageInterpolator;
    }

    private MessageInterpolator getMessageInterpolator() {
        try {
            return Validation.byDefaultProvider().configure().getDefaultMessageInterpolator();
        }
        catch (ValidationException ex) {
            MessageInterpolator fallback = this.getFallback();
            if (fallback != null) {
                return fallback;
            }
            throw ex;
        }
    }

    @Nullable
    private MessageInterpolator getFallback() {
        for (String fallback : FALLBACKS) {
            try {
                return this.getFallback(fallback);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private MessageInterpolator getFallback(String fallback) {
        Class interpolatorClass = ClassUtils.resolveClassName((String)fallback, null);
        Object interpolator = BeanUtils.newInstance((Class)interpolatorClass);
        return (MessageInterpolator)interpolator;
    }

    static {
        LinkedHashSet<String> fallbacks = new LinkedHashSet<String>();
        fallbacks.add("org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator");
        FALLBACKS = Collections.unmodifiableSet(fallbacks);
    }
}

