/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation;

import cn.taketoday.beans.BeanWrapper;
import cn.taketoday.beans.ConfigurablePropertyAccessor;
import cn.taketoday.lang.Nullable;
import cn.taketoday.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    @Nullable
    private final Object target;
    private final boolean autoGrowNestedPaths;
    @Nullable
    private transient ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(@Nullable Object target, String objectName) {
        this(target, objectName, true);
    }

    public DirectFieldBindingResult(@Nullable Object target, String objectName, boolean autoGrowNestedPaths) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    @Override
    @Nullable
    public final Object getTarget() {
        return this.target;
    }

    @Override
    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
            this.directFieldAccessor.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        if (this.target == null) {
            throw new IllegalStateException("Cannot access fields on null target instance '" + this.getObjectName() + "'");
        }
        return BeanWrapper.forDirectFieldAccess((Object)this.target);
    }
}

