/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation;

import cn.taketoday.beans.ConfigurablePropertyAccessor;
import cn.taketoday.beans.PropertyAccessException;
import cn.taketoday.beans.PropertyAccessorUtils;
import cn.taketoday.beans.PropertyBatchUpdateException;
import cn.taketoday.beans.PropertyEditorRegistry;
import cn.taketoday.beans.PropertyValue;
import cn.taketoday.beans.PropertyValues;
import cn.taketoday.beans.SimpleTypeConverter;
import cn.taketoday.beans.TypeConverter;
import cn.taketoday.beans.TypeMismatchException;
import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.format.Formatter;
import cn.taketoday.format.support.FormatterPropertyEditorAdapter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import cn.taketoday.validation.AbstractPropertyBindingResult;
import cn.taketoday.validation.BeanPropertyBindingResult;
import cn.taketoday.validation.BindException;
import cn.taketoday.validation.BindingErrorProcessor;
import cn.taketoday.validation.BindingResult;
import cn.taketoday.validation.DefaultBindingErrorProcessor;
import cn.taketoday.validation.DirectFieldBindingResult;
import cn.taketoday.validation.MessageCodesResolver;
import cn.taketoday.validation.SmartValidator;
import cn.taketoday.validation.Validator;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataBinder
implements PropertyEditorRegistry,
TypeConverter {
    public static final String DEFAULT_OBJECT_NAME = "target";
    public static final int DEFAULT_AUTO_GROW_COLLECTION_LIMIT = 256;
    protected static final Logger logger = LoggerFactory.getLogger(DataBinder.class);
    @Nullable
    private final Object target;
    private final String objectName;
    @Nullable
    private AbstractPropertyBindingResult bindingResult;
    private boolean directFieldAccess = false;
    @Nullable
    private SimpleTypeConverter typeConverter;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private boolean autoGrowNestedPaths = true;
    private int autoGrowCollectionLimit = 256;
    @Nullable
    private String[] allowedFields;
    @Nullable
    private String[] disallowedFields;
    @Nullable
    private String[] requiredFields;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private MessageCodesResolver messageCodesResolver;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    private final ArrayList<Validator> validators = new ArrayList();

    public DataBinder(@Nullable Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(@Nullable Object target, String objectName) {
        this.target = ObjectUtils.unwrapOptional((Object)target);
        this.objectName = objectName;
    }

    @Nullable
    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call setAutoGrowNestedPaths before other configuration methods");
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public boolean isAutoGrowNestedPaths() {
        return this.autoGrowNestedPaths;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call setAutoGrowCollectionLimit before other configuration methods");
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void initBeanPropertyAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initBeanPropertyAccess before other configuration methods");
        this.directFieldAccess = false;
    }

    protected AbstractPropertyBindingResult createBeanPropertyBindingResult() {
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        if (this.messageCodesResolver != null) {
            result.setMessageCodesResolver(this.messageCodesResolver);
        }
        return result;
    }

    public void initDirectFieldAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initDirectFieldAccess before other configuration methods");
        this.directFieldAccess = true;
    }

    protected AbstractPropertyBindingResult createDirectFieldBindingResult() {
        DirectFieldBindingResult result = new DirectFieldBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        if (this.messageCodesResolver != null) {
            result.setMessageCodesResolver(this.messageCodesResolver);
        }
        return result;
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        AbstractPropertyBindingResult bindingResult = this.bindingResult;
        if (bindingResult == null) {
            this.bindingResult = bindingResult = this.directFieldAccess ? this.createDirectFieldBindingResult() : this.createBeanPropertyBindingResult();
        }
        return bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    protected SimpleTypeConverter getSimpleTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new SimpleTypeConverter();
            if (this.conversionService != null) {
                this.typeConverter.setConversionService(this.conversionService);
            }
        }
        return this.typeConverter;
    }

    protected PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    protected TypeConverter getTypeConverter() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String ... allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])allowedFields);
    }

    @Nullable
    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String ... disallowedFields) {
        if (disallowedFields == null) {
            this.disallowedFields = null;
        } else {
            String[] fieldPatterns = new String[disallowedFields.length];
            for (int i = 0; i < fieldPatterns.length; ++i) {
                fieldPatterns[i] = PropertyAccessorUtils.canonicalPropertyName((String)disallowedFields[i]).toLowerCase();
            }
            this.disallowedFields = fieldPatterns;
        }
    }

    @Nullable
    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String ... requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug("DataBinder requires binding of required fields [{}]", (Object)StringUtils.arrayToCommaDelimitedString((Object[])requiredFields));
        }
    }

    @Nullable
    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setMessageCodesResolver(@Nullable MessageCodesResolver messageCodesResolver) {
        Assert.state((this.messageCodesResolver == null ? 1 : 0) != 0, (String)"DataBinder is already initialized with MessageCodesResolver");
        this.messageCodesResolver = messageCodesResolver;
        if (this.bindingResult != null && messageCodesResolver != null) {
            this.bindingResult.setMessageCodesResolver(messageCodesResolver);
        }
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        Assert.notNull((Object)bindingErrorProcessor, (String)"BindingErrorProcessor must not be null");
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void setValidator(@Nullable Validator validator) {
        this.assertValidators(validator);
        this.validators.clear();
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    private void assertValidators(Validator ... validators) {
        Object target = this.getTarget();
        for (Validator validator : validators) {
            if (validator == null || target == null || validator.supports(target.getClass())) continue;
            throw new IllegalStateException("Invalid target for Validator [" + validator + "]: " + target);
        }
    }

    public void addValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.addAll(Arrays.asList(validators));
    }

    public void replaceValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.clear();
        this.validators.addAll(Arrays.asList(validators));
    }

    @Nullable
    public Validator getValidator() {
        return !this.validators.isEmpty() ? this.validators.get(0) : null;
    }

    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        Assert.state((this.conversionService == null ? 1 : 0) != 0, (String)"DataBinder is already initialized with ConversionService");
        this.conversionService = conversionService;
        if (this.bindingResult != null && conversionService != null) {
            this.bindingResult.initConversion(conversionService);
        }
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addCustomFormatter(Formatter<?> formatter) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        this.getPropertyEditorRegistry().registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
    }

    public void addCustomFormatter(Formatter<?> formatter, String ... fields) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        Class<?> fieldType = adapter.getFieldType();
        PropertyEditorRegistry registry = this.getPropertyEditorRegistry();
        if (ObjectUtils.isEmpty((Object[])fields)) {
            registry.registerCustomEditor(fieldType, (PropertyEditor)adapter);
        } else {
            for (String field : fields) {
                registry.registerCustomEditor(fieldType, field, (PropertyEditor)adapter);
            }
        }
    }

    public void addCustomFormatter(Formatter<?> formatter, Class<?> ... fieldTypes) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        PropertyEditorRegistry editorRegistry = this.getPropertyEditorRegistry();
        if (ObjectUtils.isEmpty((Object[])fieldTypes)) {
            editorRegistry.registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
        } else {
            for (Class<?> fieldType : fieldTypes) {
                editorRegistry.registerCustomEditor(fieldType, (PropertyEditor)adapter);
            }
        }
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(@Nullable Class<?> requiredType, @Nullable String field, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, field, propertyEditor);
    }

    @Nullable
    public PropertyEditor findCustomEditor(@Nullable Class<?> requiredType, @Nullable String propertyPath) {
        return this.getPropertyEditorRegistry().findCustomEditor(requiredType, propertyPath);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable MethodParameter methodParam) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, methodParam);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable Field field) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, field);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable TypeDescriptor typeDescriptor) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, typeDescriptor);
    }

    public void bind(PropertyValues pvs) {
        this.doBind(pvs);
    }

    protected void doBind(PropertyValues values) {
        this.checkAllowedFields(values);
        this.checkRequiredFields(values);
        this.applyPropertyValues(values);
    }

    protected void checkAllowedFields(PropertyValues mpvs) {
        for (PropertyValue pv : mpvs.toArray()) {
            String field = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
            if (this.isAllowed(field)) continue;
            mpvs.remove(pv);
            this.getBindingResult().recordSuppressedField(field);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Field [{}] has been removed from PropertyValues and will not be bound, because it has not been found in the list of allowed fields", (Object)field);
        }
    }

    protected boolean isAllowed(String field) {
        Object[] allowed = this.getAllowedFields();
        Object[] disallowed = this.getDisallowedFields();
        return !(!ObjectUtils.isEmpty((Object[])allowed) && !StringUtils.simpleMatch((String[])allowed, (String)field) || !ObjectUtils.isEmpty((Object[])disallowed) && StringUtils.simpleMatch((String[])disallowed, (String)field.toLowerCase()));
    }

    protected void checkRequiredFields(PropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (ObjectUtils.isNotEmpty((Object[])requiredFields)) {
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            for (PropertyValue pv : mpvs) {
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
                propertyValues.put(canonicalName, pv);
            }
            BindingErrorProcessor bindingErrorProcessor = this.getBindingErrorProcessor();
            for (Object field : requiredFields) {
                boolean empty;
                PropertyValue pv = (PropertyValue)propertyValues.get(field);
                boolean bl = empty = pv == null || pv.getValue() == null;
                if (!empty) {
                    if (pv.getValue() instanceof String) {
                        empty = StringUtils.isBlank((String)((String)pv.getValue()));
                    } else {
                        Object object = pv.getValue();
                        if (object instanceof String[]) {
                            String[] values = (String[])object;
                            boolean bl2 = empty = values.length == 0 || StringUtils.isBlank((String)values[0]);
                        }
                    }
                }
                if (!empty) continue;
                bindingErrorProcessor.processMissingFieldError((String)field, this.getInternalBindingResult());
                if (pv == null) continue;
                mpvs.remove(pv);
                propertyValues.remove(field);
            }
        }
    }

    protected void applyPropertyValues(PropertyValues mpvs) {
        try {
            this.getPropertyAccessor().setPropertyValues(mpvs, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
        }
        catch (PropertyBatchUpdateException ex) {
            for (PropertyAccessException pae : ex.getPropertyAccessExceptions()) {
                this.getBindingErrorProcessor().processPropertyAccessException(pae, this.getInternalBindingResult());
            }
        }
    }

    public void validate() {
        Object target = this.getTarget();
        Assert.state((target != null ? 1 : 0) != 0, (String)"No target to validate");
        BindingResult bindingResult = this.getBindingResult();
        for (Validator validator : this.getValidators()) {
            validator.validate(target, bindingResult);
        }
    }

    public void validate(Object ... validationHints) {
        Object target = this.getTarget();
        Assert.state((target != null ? 1 : 0) != 0, (String)"No target to validate");
        BindingResult bindingResult = this.getBindingResult();
        for (Validator validator : this.getValidators()) {
            if (ObjectUtils.isNotEmpty((Object[])validationHints) && validator instanceof SmartValidator) {
                ((SmartValidator)validator).validate(target, bindingResult, validationHints);
                continue;
            }
            if (validator == null) continue;
            validator.validate(target, bindingResult);
        }
    }

    public Map<?, ?> close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }
}

