/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.ui;

import cn.taketoday.core.Conventions;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.ui.Model;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ModelMap
extends LinkedHashMap<String, Object>
implements Model {
    public ModelMap() {
    }

    public ModelMap(String attributeName, @Nullable Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ModelMap(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    @Override
    public ModelMap addAttribute(String attributeName, @Nullable Object attributeValue) {
        Assert.notNull((Object)attributeName, (String)"Model attribute name must not be null");
        this.put(attributeName, attributeValue);
        return this;
    }

    @Override
    public ModelMap addAttribute(Object attributeValue) {
        Assert.notNull((Object)attributeValue, (String)"Model object must not be null");
        if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName((Object)attributeValue), attributeValue);
    }

    @Override
    public ModelMap addAllAttributes(@Nullable Collection<?> attributeValues) {
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                this.addAttribute(attributeValue);
            }
        }
        return this;
    }

    @Override
    public ModelMap addAllAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            this.putAll(attributes);
        }
        return this;
    }

    @Override
    public ModelMap mergeAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            attributes.forEach((key, value) -> {
                if (!this.containsKey(key)) {
                    this.put(key, value);
                }
            });
        }
        return this;
    }

    @Override
    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    @Override
    @Nullable
    public Object getAttribute(String attributeName) {
        return this.get(attributeName);
    }

    @Override
    public void setAttribute(String name, @Nullable Object value) {
        this.put(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        return this.remove(name);
    }

    @Override
    public Map<String, Object> asMap() {
        return this;
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.keySet().iterator();
    }
}

