/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.ui;

import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public interface Model {
    default public boolean containsAttribute(String name) {
        return this.getAttribute(name) == null;
    }

    default public void setAttributes(Map<String, Object> attributes) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Nullable
    public Object getAttribute(String var1);

    public void setAttribute(String var1, @Nullable Object var2);

    public Model addAttribute(String var1, @Nullable Object var2);

    public Object removeAttribute(String var1);

    public Map<String, Object> asMap();

    public void clear();

    public boolean isEmpty();

    default public String[] getAttributeNames() {
        return (String[])CollectionUtils.toArray(this.attributeNames(), (Object[])Constant.EMPTY_STRING_ARRAY);
    }

    public Iterator<String> attributeNames();

    public Model addAttribute(@Nullable Object var1);

    public Model addAllAttributes(@Nullable Collection<?> var1);

    public Model addAllAttributes(@Nullable Map<String, ?> var1);

    public Model mergeAttributes(@Nullable Map<String, ?> var1);
}

