/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.support;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scripting.ScriptSource;

public class StaticScriptSource
implements ScriptSource {
    private String script = "";
    private boolean modified;
    @Nullable
    private String className;

    public StaticScriptSource(String script) {
        this.setScript(script);
    }

    public StaticScriptSource(String script, @Nullable String className) {
        this.setScript(script);
        this.className = className;
    }

    public synchronized void setScript(String script) {
        Assert.hasText((String)script, (String)"Script must not be empty");
        this.modified = !script.equals(this.script);
        this.script = script;
    }

    @Override
    public synchronized String getScriptAsString() {
        this.modified = false;
        return this.script;
    }

    @Override
    public synchronized boolean isModified() {
        return this.modified;
    }

    @Override
    @Nullable
    public String suggestedClassName() {
        return this.className;
    }

    public String toString() {
        return "static script" + (String)(this.className != null ? " [" + this.className + "]" : "");
    }
}

