/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.support;

import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.core.ConstructorNotFoundException;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scripting.ScriptCompilationException;
import cn.taketoday.scripting.ScriptFactory;
import cn.taketoday.scripting.ScriptSource;
import cn.taketoday.scripting.support.ResourceScriptSource;
import cn.taketoday.scripting.support.StandardScriptUtils;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class StandardScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    @Nullable
    private final String scriptEngineName;
    private final String scriptSourceLocator;
    @Nullable
    private final Class<?>[] scriptInterfaces;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private volatile ScriptEngine scriptEngine;

    public StandardScriptFactory(String scriptSourceLocator) {
        this(null, scriptSourceLocator, (Class[])null);
    }

    public StandardScriptFactory(String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        this(null, scriptSourceLocator, scriptInterfaces);
    }

    public StandardScriptFactory(String scriptEngineName, String scriptSourceLocator) {
        this(scriptEngineName, scriptSourceLocator, (Class[])null);
    }

    public StandardScriptFactory(@Nullable String scriptEngineName, String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        this.scriptEngineName = scriptEngineName;
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    @Nullable
    public Class<?>[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    @Override
    public boolean requiresConfigInterface() {
        return false;
    }

    @Override
    @Nullable
    public Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        Object script = this.evaluateScript(scriptSource);
        if (ObjectUtils.isNotEmpty((Object[])actualInterfaces)) {
            boolean adaptationRequired = false;
            for (Class<?> requestedIfc : actualInterfaces) {
                if (!(script instanceof Class ? !requestedIfc.isAssignableFrom((Class)script) : !requestedIfc.isInstance(script))) continue;
                adaptationRequired = true;
                break;
            }
            if (adaptationRequired) {
                script = this.adaptToInterfaces(script, scriptSource, actualInterfaces);
            }
        }
        if (script instanceof Class) {
            Class scriptClass = (Class)script;
            try {
                return ReflectionUtils.accessibleConstructor((Class)scriptClass, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            catch (ConstructorNotFoundException ex) {
                throw new ScriptCompilationException("No default constructor on script class: " + scriptClass.getName(), (Throwable)ex);
            }
            catch (InstantiationException ex) {
                throw new ScriptCompilationException(scriptSource, "Unable to instantiate script class: " + scriptClass.getName(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new ScriptCompilationException(scriptSource, "Could not access script constructor: " + scriptClass.getName(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new ScriptCompilationException("Failed to invoke script constructor: " + scriptClass.getName(), ex.getTargetException());
            }
        }
        return script;
    }

    protected Object evaluateScript(ScriptSource scriptSource) {
        try {
            ScriptEngine scriptEngine = this.scriptEngine;
            if (scriptEngine == null) {
                scriptEngine = this.retrieveScriptEngine(scriptSource);
                if (scriptEngine == null) {
                    throw new IllegalStateException("Could not determine script engine for " + scriptSource);
                }
                this.scriptEngine = scriptEngine;
            }
            return scriptEngine.eval(scriptSource.getScriptAsString());
        }
        catch (Exception ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    @Nullable
    protected ScriptEngine retrieveScriptEngine(ScriptSource scriptSource) {
        String extension;
        String filename;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(this.beanClassLoader);
        if (this.scriptEngineName != null) {
            return StandardScriptUtils.retrieveEngineByName(scriptEngineManager, this.scriptEngineName);
        }
        if (scriptSource instanceof ResourceScriptSource && (filename = ((ResourceScriptSource)scriptSource).getResource().getName()) != null && (extension = StringUtils.getFilenameExtension((String)filename)) != null) {
            return scriptEngineManager.getEngineByExtension(extension);
        }
        return null;
    }

    @Nullable
    protected Object adaptToInterfaces(@Nullable Object script, ScriptSource scriptSource, Class<?> ... actualInterfaces) {
        Class adaptedIfc = actualInterfaces.length == 1 ? actualInterfaces[0] : ClassUtils.createCompositeInterface((Class[])actualInterfaces, (ClassLoader)this.beanClassLoader);
        if (adaptedIfc != null) {
            ScriptEngine scriptEngine = this.scriptEngine;
            if (!(scriptEngine instanceof Invocable)) {
                throw new ScriptCompilationException(scriptSource, "ScriptEngine must implement Invocable in order to adapt it to an interface: " + scriptEngine);
            }
            Invocable invocable = (Invocable)((Object)scriptEngine);
            if (script != null) {
                script = invocable.getInterface(script, adaptedIfc);
            }
            if (script == null && (script = invocable.getInterface(adaptedIfc)) == null) {
                throw new ScriptCompilationException(scriptSource, "Could not adapt script to interface [" + adaptedIfc.getName() + "]");
            }
        }
        return script;
    }

    @Override
    @Nullable
    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        return null;
    }

    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        return scriptSource.isModified();
    }

    public String toString() {
        return "StandardScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

