/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.support;

import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.aop.support.DelegatingIntroductionInterceptor;
import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.PropertyValues;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanCreationException;
import cn.taketoday.beans.factory.BeanCurrentlyInCreationException;
import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.BeanDefinitionValidationException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.ConstructorArgumentValues;
import cn.taketoday.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.GenericBeanDefinition;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.proxy.InterfaceMaker;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.core.Conventions;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.scripting.ScriptFactory;
import cn.taketoday.scripting.ScriptSource;
import cn.taketoday.scripting.support.RefreshableScriptTargetSource;
import cn.taketoday.scripting.support.ResourceScriptSource;
import cn.taketoday.scripting.support.StaticScriptSource;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;

public class ScriptFactoryPostProcessor
implements SmartInstantiationAwareBeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
ResourceLoaderAware,
DisposableBean,
Ordered {
    public static final String INLINE_SCRIPT_PREFIX = "inline:";
    public static final String REFRESH_CHECK_DELAY_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"refreshCheckDelay");
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"proxyTargetClass");
    public static final String LANGUAGE_ATTRIBUTE = Conventions.getQualifiedAttributeName(ScriptFactoryPostProcessor.class, (String)"language");
    private static final String SCRIPT_FACTORY_NAME_PREFIX = "scriptFactory.";
    private static final String SCRIPTED_OBJECT_NAME_PREFIX = "scriptedObject.";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private long defaultRefreshCheckDelay = -1L;
    private boolean defaultProxyTargetClass = false;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private ConfigurableBeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    final StandardBeanFactory scriptBeanFactory = new StandardBeanFactory();
    private final Map<String, ScriptSource> scriptSourceCache = new ConcurrentHashMap<String, ScriptSource>();

    public void setDefaultRefreshCheckDelay(long defaultRefreshCheckDelay) {
        this.defaultRefreshCheckDelay = defaultRefreshCheckDelay;
    }

    public void setDefaultProxyTargetClass(boolean defaultProxyTargetClass) {
        this.defaultProxyTargetClass = defaultProxyTargetClass;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("ScriptFactoryPostProcessor doesn't work with non-ConfigurableBeanFactory: " + beanFactory.getClass());
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        this.scriptBeanFactory.setParentBeanFactory((BeanFactory)this.beanFactory);
        this.scriptBeanFactory.copyConfigurationFrom(this.beanFactory);
        this.scriptBeanFactory.getBeanPostProcessors().removeIf(beanPostProcessor -> beanPostProcessor instanceof AopInfrastructureBean);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Nullable
    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        block8: {
            if (!ScriptFactory.class.isAssignableFrom(beanClass)) {
                return null;
            }
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory set");
            BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
            try {
                String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
                String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
                this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
                ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
                ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
                Object[] interfaces = scriptFactory.getScriptInterfaces();
                Class<?> scriptedType = scriptFactory.getScriptedObjectType(scriptSource);
                if (scriptedType != null) {
                    return scriptedType;
                }
                if (ObjectUtils.isNotEmpty((Object[])interfaces)) {
                    return interfaces.length == 1 ? interfaces[0] : this.createCompositeInterface((Class<?>[])interfaces);
                }
                if (bd.isSingleton()) {
                    return this.scriptBeanFactory.getBean(scriptedObjectBeanName).getClass();
                }
            }
            catch (Exception ex) {
                if (ex instanceof BeanCreationException && ((BeanCreationException)ex).getMostSpecificCause() instanceof BeanCurrentlyInCreationException) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Could not determine scripted object type for bean '{}': {}", (Object)beanName, (Object)ex.getMessage());
                    }
                }
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug("Could not determine scripted object type for bean '{}'", (Object)beanName, (Object)ex);
            }
        }
        return null;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) {
        if (!ScriptFactory.class.isAssignableFrom(beanClass)) {
            return null;
        }
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory set");
        BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        String scriptFactoryBeanName = SCRIPT_FACTORY_NAME_PREFIX + beanName;
        String scriptedObjectBeanName = SCRIPTED_OBJECT_NAME_PREFIX + beanName;
        this.prepareScriptBeans(bd, scriptFactoryBeanName, scriptedObjectBeanName);
        ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
        ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
        boolean isFactoryBean = false;
        try {
            Class<?> scriptedObjectType = scriptFactory.getScriptedObjectType(scriptSource);
            if (scriptedObjectType != null) {
                isFactoryBean = FactoryBean.class.isAssignableFrom(scriptedObjectType);
            }
        }
        catch (Exception ex) {
            throw new BeanCreationException(beanName, "Could not determine scripted object type for " + scriptFactory, (Throwable)ex);
        }
        long refreshCheckDelay = this.resolveRefreshCheckDelay(bd);
        if (refreshCheckDelay >= 0L) {
            Class<?>[] interfaces = scriptFactory.getScriptInterfaces();
            RefreshableScriptTargetSource ts = new RefreshableScriptTargetSource((BeanFactory)this.scriptBeanFactory, scriptedObjectBeanName, scriptFactory, scriptSource, isFactoryBean);
            boolean proxyTargetClass = this.resolveProxyTargetClass(bd);
            String language = (String)bd.getAttribute(LANGUAGE_ATTRIBUTE);
            if (proxyTargetClass && (language == null || !language.equals("groovy"))) {
                throw new BeanDefinitionValidationException("Cannot use proxyTargetClass=true with script beans where language is not 'groovy': '" + language + "'");
            }
            ts.setRefreshCheckDelay(refreshCheckDelay);
            return this.createRefreshableProxy((TargetSource)ts, interfaces, proxyTargetClass);
        }
        if (isFactoryBean) {
            scriptedObjectBeanName = "&" + scriptedObjectBeanName;
        }
        return this.scriptBeanFactory.getBean(scriptedObjectBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareScriptBeans(BeanDefinition bd, String scriptFactoryBeanName, String scriptedObjectBeanName) {
        StandardBeanFactory standardBeanFactory = this.scriptBeanFactory;
        synchronized (standardBeanFactory) {
            if (!this.scriptBeanFactory.containsBeanDefinition(scriptedObjectBeanName)) {
                Object[] interfaces;
                this.scriptBeanFactory.registerBeanDefinition(scriptFactoryBeanName, this.createScriptFactoryBeanDefinition(bd));
                ScriptFactory scriptFactory = (ScriptFactory)this.scriptBeanFactory.getBean(scriptFactoryBeanName, ScriptFactory.class);
                ScriptSource scriptSource = this.getScriptSource(scriptFactoryBeanName, scriptFactory.getScriptSourceLocator());
                Object[] scriptedInterfaces = interfaces = scriptFactory.getScriptInterfaces();
                if (scriptFactory.requiresConfigInterface() && bd.hasPropertyValues()) {
                    Class<?> configInterface = this.createConfigInterface(bd, (Class<?>[])interfaces);
                    scriptedInterfaces = (Class[])ObjectUtils.addObjectToArray((Object[])interfaces, configInterface);
                }
                BeanDefinition objectBd = this.createScriptedObjectBeanDefinition(bd, scriptFactoryBeanName, scriptSource, (Class<?>[])scriptedInterfaces);
                long refreshCheckDelay = this.resolveRefreshCheckDelay(bd);
                if (refreshCheckDelay >= 0L) {
                    objectBd.setScope("prototype");
                }
                this.scriptBeanFactory.registerBeanDefinition(scriptedObjectBeanName, objectBd);
            }
        }
    }

    protected long resolveRefreshCheckDelay(BeanDefinition beanDefinition) {
        long refreshCheckDelay = this.defaultRefreshCheckDelay;
        Object attributeValue = beanDefinition.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (attributeValue instanceof Number) {
            refreshCheckDelay = ((Number)attributeValue).longValue();
        } else if (attributeValue instanceof String) {
            refreshCheckDelay = Long.parseLong((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid refresh check delay attribute [" + REFRESH_CHECK_DELAY_ATTRIBUTE + "] with value '" + attributeValue + "': needs to be of type Number or String");
        }
        return refreshCheckDelay;
    }

    protected boolean resolveProxyTargetClass(BeanDefinition beanDefinition) {
        boolean proxyTargetClass = this.defaultProxyTargetClass;
        Object attributeValue = beanDefinition.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE);
        if (attributeValue instanceof Boolean) {
            proxyTargetClass = (Boolean)attributeValue;
        } else if (attributeValue instanceof String) {
            proxyTargetClass = Boolean.parseBoolean((String)attributeValue);
        } else if (attributeValue != null) {
            throw new BeanDefinitionStoreException("Invalid proxy target class attribute [" + PROXY_TARGET_CLASS_ATTRIBUTE + "] with value '" + attributeValue + "': needs to be of type Boolean or String");
        }
        return proxyTargetClass;
    }

    protected BeanDefinition createScriptFactoryBeanDefinition(BeanDefinition bd) {
        GenericBeanDefinition scriptBd = new GenericBeanDefinition();
        scriptBd.setBeanClassName(bd.getBeanClassName());
        scriptBd.getConstructorArgumentValues().addArgumentValues(bd.getConstructorArgumentValues());
        return scriptBd;
    }

    protected ScriptSource getScriptSource(String beanName, String scriptSourceLocator) {
        return this.scriptSourceCache.computeIfAbsent(beanName, key -> this.convertToScriptSource(beanName, scriptSourceLocator, this.resourceLoader));
    }

    protected ScriptSource convertToScriptSource(String beanName, String scriptSourceLocator, ResourceLoader resourceLoader) {
        if (scriptSourceLocator.startsWith(INLINE_SCRIPT_PREFIX)) {
            return new StaticScriptSource(scriptSourceLocator.substring(INLINE_SCRIPT_PREFIX.length()), beanName);
        }
        return new ResourceScriptSource(resourceLoader.getResource(scriptSourceLocator));
    }

    protected Class<?> createConfigInterface(BeanDefinition bd, @Nullable Class<?>[] interfaces) {
        MethodSignature signature;
        InterfaceMaker maker = new InterfaceMaker();
        PropertyValues propertyValues = bd.getPropertyValues();
        if (propertyValues != null) {
            for (String[] pv : propertyValues) {
                String propertyName = pv.getName();
                Class propertyType = BeanUtils.findPropertyType((String)propertyName, (Class[])interfaces);
                String setterName = "set" + StringUtils.capitalize((String)propertyName);
                signature = new MethodSignature(Type.VOID_TYPE, setterName, new Type[]{Type.fromClass((Class)propertyType)});
                maker.add(signature, Type.EMPTY_ARRAY);
            }
        }
        if (bd instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abd = (AbstractBeanDefinition)bd;
            if (ObjectUtils.isNotEmpty((Object[])abd.getInitMethodNames())) {
                for (String initMethodName : abd.getInitMethodNames()) {
                    signature = new MethodSignature(Type.VOID_TYPE, initMethodName, new Type[0]);
                    maker.add(signature, Type.EMPTY_ARRAY);
                }
            }
            if (ObjectUtils.isNotEmpty((Object[])abd.getDestroyMethodNames())) {
                for (String destroyMethodName : abd.getDestroyMethodNames()) {
                    signature = new MethodSignature(Type.VOID_TYPE, destroyMethodName, new Type[0]);
                    maker.add(signature, Type.EMPTY_ARRAY);
                }
            }
        } else {
            MethodSignature signature2;
            if (StringUtils.hasText((String)bd.getDestroyMethodName())) {
                signature2 = new MethodSignature(Type.VOID_TYPE, bd.getDestroyMethodName(), new Type[0]);
                maker.add(signature2, Type.EMPTY_ARRAY);
            }
            if (StringUtils.hasText((String)bd.getDestroyMethodName())) {
                signature2 = new MethodSignature(Type.VOID_TYPE, bd.getDestroyMethodName(), new Type[0]);
                maker.add(signature2, Type.EMPTY_ARRAY);
            }
        }
        return maker.create();
    }

    protected Class<?> createCompositeInterface(Class<?>[] interfaces) {
        return ClassUtils.createCompositeInterface((Class[])interfaces, (ClassLoader)this.beanClassLoader);
    }

    protected BeanDefinition createScriptedObjectBeanDefinition(BeanDefinition bd, String scriptFactoryBeanName, ScriptSource scriptSource, @Nullable Class<?>[] interfaces) {
        BeanDefinition objectBd = bd.cloneBeanDefinition();
        objectBd.setFactoryBeanName(scriptFactoryBeanName);
        objectBd.setFactoryMethodName("getScriptedObject");
        ConstructorArgumentValues argumentValues = objectBd.getConstructorArgumentValues();
        argumentValues.clear();
        argumentValues.addIndexedArgumentValue(0, (Object)scriptSource);
        argumentValues.addIndexedArgumentValue(1, interfaces);
        return objectBd;
    }

    protected Object createRefreshableProxy(TargetSource ts, @Nullable Class<?>[] interfaces, boolean proxyTargetClass) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(ts);
        ClassLoader classLoader = this.beanClassLoader;
        if (interfaces != null) {
            proxyFactory.setInterfaces((Class[])interfaces);
        } else {
            Class targetClass = ts.getTargetClass();
            if (targetClass != null) {
                proxyFactory.setInterfaces(ClassUtils.getAllInterfacesForClass((Class)targetClass, (ClassLoader)this.beanClassLoader));
            }
        }
        if (proxyTargetClass) {
            classLoader = null;
            proxyFactory.setProxyTargetClass(true);
        }
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor((Object)ts);
        introduction.suppressInterface(TargetSource.class);
        proxyFactory.addAdvice((Advice)introduction);
        return proxyFactory.getProxy(classLoader);
    }

    public void destroy() {
        this.scriptBeanFactory.destroySingletons();
    }
}

