/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.support;

import cn.taketoday.core.io.EncodedResource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.scripting.ScriptSource;
import cn.taketoday.util.FileCopyUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ResourceScriptSource
implements ScriptSource {
    private static final Logger log = LoggerFactory.getLogger(ResourceScriptSource.class);
    private EncodedResource resource;
    private long lastModified = -1L;
    private final Object lastModifiedMonitor = new Object();

    public ResourceScriptSource(EncodedResource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.resource = resource;
    }

    public ResourceScriptSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.resource = new EncodedResource(resource, StandardCharsets.UTF_8);
    }

    public final Resource getResource() {
        return this.resource.getResource();
    }

    public void setEncoding(@Nullable String encoding) {
        this.resource = new EncodedResource(this.resource.getResource(), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScriptAsString() throws IOException {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            this.lastModified = this.retrieveLastModifiedTime();
        }
        Reader reader = this.resource.getReader();
        return FileCopyUtils.copyToString((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            return this.lastModified < 0L || this.retrieveLastModifiedTime() > this.lastModified;
        }
    }

    protected long retrieveLastModifiedTime() {
        try {
            return this.getResource().lastModified();
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug(this.getResource() + " could not be resolved in the file system - current timestamp not available for script modification check", (Throwable)ex);
            }
            return 0L;
        }
    }

    @Override
    @Nullable
    public String suggestedClassName() {
        String filename = this.getResource().getName();
        return filename != null ? StringUtils.stripFilenameExtension((String)filename) : null;
    }

    public String toString() {
        return this.resource.toString();
    }
}

