/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.support;

import cn.taketoday.aop.target.BeanFactoryRefreshableTargetSource;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.scripting.ScriptFactory;
import cn.taketoday.scripting.ScriptSource;

public class RefreshableScriptTargetSource
extends BeanFactoryRefreshableTargetSource {
    private final ScriptFactory scriptFactory;
    private final ScriptSource scriptSource;
    private final boolean isFactoryBean;

    public RefreshableScriptTargetSource(BeanFactory beanFactory, String beanName, ScriptFactory scriptFactory, ScriptSource scriptSource, boolean isFactoryBean) {
        super(beanFactory, beanName);
        Assert.notNull((Object)scriptFactory, (String)"ScriptFactory must not be null");
        Assert.notNull((Object)scriptSource, (String)"ScriptSource must not be null");
        this.scriptFactory = scriptFactory;
        this.scriptSource = scriptSource;
        this.isFactoryBean = isFactoryBean;
    }

    protected boolean requiresRefresh() {
        return this.scriptFactory.requiresScriptedObjectRefresh(this.scriptSource);
    }

    protected Object obtainFreshBean(BeanFactory beanFactory, String beanName) {
        return super.obtainFreshBean(beanFactory, (String)(this.isFactoryBean ? "&" + beanName : beanName));
    }
}

