/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.config;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.TypedStringValue;
import cn.taketoday.beans.factory.xml.BeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import cn.taketoday.scripting.config.LangNamespaceUtils;
import cn.taketoday.util.StringUtils;
import org.w3c.dom.Element;

class ScriptingDefaultsParser
implements BeanDefinitionParser {
    private static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";
    private static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";

    ScriptingDefaultsParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String proxyTargetClass;
        BeanDefinition bd = LangNamespaceUtils.registerScriptFactoryPostProcessorIfNecessary(parserContext.getRegistry());
        String refreshCheckDelay = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (StringUtils.hasText((String)refreshCheckDelay)) {
            bd.getPropertyValues().add("defaultRefreshCheckDelay", (Object)Long.valueOf(refreshCheckDelay));
        }
        if (StringUtils.hasText((String)(proxyTargetClass = element.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE)))) {
            bd.getPropertyValues().add("defaultProxyTargetClass", (Object)new TypedStringValue(proxyTargetClass, Boolean.class));
        }
        return null;
    }
}

