/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scripting.ScriptCompilationException;
import cn.taketoday.scripting.ScriptEvaluator;
import cn.taketoday.scripting.ScriptSource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public class BshScriptEvaluator
implements ScriptEvaluator,
BeanClassLoaderAware {
    @Nullable
    private ClassLoader classLoader;

    public BshScriptEvaluator() {
    }

    public BshScriptEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public Object evaluate(ScriptSource script) {
        return this.evaluate(script, null);
    }

    @Override
    @Nullable
    public Object evaluate(ScriptSource script, @Nullable Map<String, Object> arguments) {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setClassLoader(this.classLoader);
            if (arguments != null) {
                for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
            }
            return interpreter.eval((Reader)new StringReader(script.getScriptAsString()));
        }
        catch (IOException ex) {
            throw new ScriptCompilationException(script, "Cannot access BeanShell script", ex);
        }
        catch (EvalError ex) {
            throw new ScriptCompilationException(script, (Throwable)ex);
        }
    }
}

