/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.scheduling.support.DelegatingErrorHandlingRunnable;
import cn.taketoday.util.ErrorHandler;
import cn.taketoday.util.ReflectionUtils;

public abstract class TaskUtils {
    public static final ErrorHandler LOG_AND_SUPPRESS_ERROR_HANDLER = new LoggingErrorHandler();
    public static final ErrorHandler LOG_AND_PROPAGATE_ERROR_HANDLER = new PropagatingErrorHandler();

    public static DelegatingErrorHandlingRunnable decorateTaskWithErrorHandler(Runnable task, @Nullable ErrorHandler errorHandler, boolean isRepeatingTask) {
        if (task instanceof DelegatingErrorHandlingRunnable) {
            return (DelegatingErrorHandlingRunnable)task;
        }
        ErrorHandler eh = errorHandler != null ? errorHandler : TaskUtils.getDefaultErrorHandler(isRepeatingTask);
        return new DelegatingErrorHandlingRunnable(task, eh);
    }

    public static ErrorHandler getDefaultErrorHandler(boolean isRepeatingTask) {
        return isRepeatingTask ? LOG_AND_SUPPRESS_ERROR_HANDLER : LOG_AND_PROPAGATE_ERROR_HANDLER;
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private final Logger logger = LoggerFactory.getLogger(LoggingErrorHandler.class);

        private LoggingErrorHandler() {
        }

        public void handleError(Throwable t) {
            this.logger.error("Unexpected error occurred in scheduled task", t);
        }
    }

    private static class PropagatingErrorHandler
    extends LoggingErrorHandler {
        private PropagatingErrorHandler() {
        }

        @Override
        public void handleError(Throwable t) {
            super.handleError(t);
            ReflectionUtils.rethrowRuntimeException((Throwable)t);
        }
    }
}

