/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.core.task.TaskDecorator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.concurrent.ThreadPoolTaskExecutor;
import cn.taketoday.scheduling.support.TaskExecutorCustomizer;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.PropertyMapper;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class TaskExecutorBuilder {
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final Integer corePoolSize;
    @Nullable
    private final Integer maxPoolSize;
    @Nullable
    private final Boolean allowCoreThreadTimeOut;
    @Nullable
    private final Duration keepAlive;
    @Nullable
    private final Boolean awaitTermination;
    @Nullable
    private final Duration awaitTerminationPeriod;
    @Nullable
    private final String threadNamePrefix;
    @Nullable
    private final TaskDecorator taskDecorator;
    @Nullable
    private final Set<TaskExecutorCustomizer> customizers;

    public TaskExecutorBuilder() {
        this.queueCapacity = null;
        this.corePoolSize = null;
        this.maxPoolSize = null;
        this.allowCoreThreadTimeOut = null;
        this.keepAlive = null;
        this.awaitTermination = null;
        this.awaitTerminationPeriod = null;
        this.threadNamePrefix = null;
        this.taskDecorator = null;
        this.customizers = null;
    }

    private TaskExecutorBuilder(@Nullable Integer queueCapacity, @Nullable Integer corePoolSize, @Nullable Integer maxPoolSize, @Nullable Boolean allowCoreThreadTimeOut, @Nullable Duration keepAlive, @Nullable Boolean awaitTermination, @Nullable Duration awaitTerminationPeriod, @Nullable String threadNamePrefix, @Nullable TaskDecorator taskDecorator, @Nullable Set<TaskExecutorCustomizer> customizers) {
        this.queueCapacity = queueCapacity;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        this.keepAlive = keepAlive;
        this.awaitTermination = awaitTermination;
        this.awaitTerminationPeriod = awaitTerminationPeriod;
        this.threadNamePrefix = threadNamePrefix;
        this.taskDecorator = taskDecorator;
        this.customizers = customizers;
    }

    public TaskExecutorBuilder queueCapacity(int queueCapacity) {
        return new TaskExecutorBuilder(queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder corePoolSize(int corePoolSize) {
        return new TaskExecutorBuilder(this.queueCapacity, corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder maxPoolSize(int maxPoolSize) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder keepAlive(@Nullable Duration keepAlive) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder awaitTermination(boolean awaitTermination) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder awaitTerminationPeriod(Duration awaitTerminationPeriod) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder threadNamePrefix(@Nullable String threadNamePrefix) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, threadNamePrefix, this.taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder taskDecorator(@Nullable TaskDecorator taskDecorator) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, taskDecorator, this.customizers);
    }

    public TaskExecutorBuilder customizers(TaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers is required");
        return this.customizers(Arrays.asList(customizers));
    }

    public TaskExecutorBuilder customizers(Iterable<TaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers is required");
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.append(null, customizers));
    }

    public TaskExecutorBuilder additionalCustomizers(TaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers is required");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public TaskExecutorBuilder additionalCustomizers(Iterable<TaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers is required");
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.awaitTermination, this.awaitTerminationPeriod, this.threadNamePrefix, this.taskDecorator, this.append(this.customizers, customizers));
    }

    public ThreadPoolTaskExecutor build() {
        return this.configure(new ThreadPoolTaskExecutor());
    }

    public <T extends ThreadPoolTaskExecutor> T build(Class<T> taskExecutorClass) {
        return (T)this.configure((ThreadPoolTaskExecutor)BeanUtils.newInstance(taskExecutorClass));
    }

    public <T extends ThreadPoolTaskExecutor> T configure(T taskExecutor) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from((Object)this.queueCapacity).to(taskExecutor::setQueueCapacity);
        map.from((Object)this.corePoolSize).to(taskExecutor::setCorePoolSize);
        map.from((Object)this.maxPoolSize).to(taskExecutor::setMaxPoolSize);
        map.from((Object)this.keepAlive).asInt(Duration::getSeconds).to(taskExecutor::setKeepAliveSeconds);
        map.from((Object)this.allowCoreThreadTimeOut).to(taskExecutor::setAllowCoreThreadTimeOut);
        map.from((Object)this.awaitTermination).to(taskExecutor::setWaitForTasksToCompleteOnShutdown);
        map.from((Object)this.awaitTerminationPeriod).as(Duration::toMillis).to(taskExecutor::setAwaitTerminationMillis);
        map.from((Object)this.threadNamePrefix).whenHasText().to(taskExecutor::setThreadNamePrefix);
        map.from((Object)this.taskDecorator).to(taskExecutor::setTaskDecorator);
        if (CollectionUtils.isNotEmpty(this.customizers)) {
            for (TaskExecutorCustomizer customizer : this.customizers) {
                customizer.customize(taskExecutor);
            }
        }
        return taskExecutor;
    }

    private <T> Set<T> append(@Nullable Set<T> set, Iterable<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set != null ? set : Collections.emptySet());
        additions.forEach(result::add);
        return Collections.unmodifiableSet(result);
    }
}

