/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

public class ScheduledMethodRunnable
implements Runnable {
    private final Object target;
    private final Method method;

    public ScheduledMethodRunnable(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public ScheduledMethodRunnable(Object target, String methodName) throws NoSuchMethodException {
        this.target = target;
        this.method = target.getClass().getMethod(methodName, new Class[0]);
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public void run() {
        try {
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(this.target, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }
}

