/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.Trigger;
import cn.taketoday.scheduling.TriggerContext;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PeriodicTrigger
implements Trigger {
    private final Duration period;
    @Nullable
    private final ChronoUnit chronoUnit;
    @Nullable
    private volatile Duration initialDelay;
    private volatile boolean fixedRate;

    public PeriodicTrigger(long period) {
        this(period, null);
    }

    public PeriodicTrigger(long period, @Nullable TimeUnit timeUnit) {
        this(PeriodicTrigger.toDuration(period, timeUnit), timeUnit);
    }

    private static Duration toDuration(long amount, @Nullable TimeUnit timeUnit) {
        if (timeUnit != null) {
            return Duration.of(amount, timeUnit.toChronoUnit());
        }
        return Duration.ofMillis(amount);
    }

    public PeriodicTrigger(Duration period) {
        this(period, null);
    }

    private PeriodicTrigger(Duration period, @Nullable TimeUnit timeUnit) {
        Assert.notNull((Object)period, (String)"Period must not be null");
        Assert.isTrue((!period.isNegative() ? 1 : 0) != 0, (String)"Period must not be negative");
        this.period = period;
        this.chronoUnit = timeUnit != null ? timeUnit.toChronoUnit() : null;
    }

    public long getPeriod() {
        if (this.chronoUnit != null) {
            return this.period.get(this.chronoUnit);
        }
        return this.period.toMillis();
    }

    public Duration getPeriodDuration() {
        return this.period;
    }

    public TimeUnit getTimeUnit() {
        if (this.chronoUnit != null) {
            return TimeUnit.of(this.chronoUnit);
        }
        return TimeUnit.MILLISECONDS;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = this.chronoUnit != null ? Duration.of(initialDelay, this.chronoUnit) : Duration.ofMillis(initialDelay);
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getInitialDelay() {
        Duration initialDelay = this.initialDelay;
        if (initialDelay != null) {
            if (this.chronoUnit != null) {
                return initialDelay.get(this.chronoUnit);
            }
            return initialDelay.toMillis();
        }
        return 0L;
    }

    @Nullable
    public Duration getInitialDelayDuration() {
        return this.initialDelay;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    @Override
    public Instant nextExecution(TriggerContext triggerContext) {
        Instant lastExecution = triggerContext.lastScheduledExecution();
        Instant lastCompletion = triggerContext.lastCompletion();
        if (lastExecution == null || lastCompletion == null) {
            Instant instant = triggerContext.getClock().instant();
            Duration initialDelay = this.initialDelay;
            if (initialDelay == null) {
                return instant;
            }
            return instant.plus(initialDelay);
        }
        if (this.fixedRate) {
            return lastExecution.plus(this.period);
        }
        return lastCompletion.plus(this.period);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PeriodicTrigger)) {
            return false;
        }
        PeriodicTrigger otherTrigger = (PeriodicTrigger)other;
        return this.fixedRate == otherTrigger.fixedRate && this.period.equals(otherTrigger.period) && Objects.equals(this.initialDelay, otherTrigger.initialDelay);
    }

    public int hashCode() {
        return this.period.hashCode();
    }
}

