/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.lang.Assert;
import cn.taketoday.util.ErrorHandler;
import java.lang.reflect.UndeclaredThrowableException;

public class DelegatingErrorHandlingRunnable
implements Runnable {
    private final Runnable delegate;
    private final ErrorHandler errorHandler;

    public DelegatingErrorHandlingRunnable(Runnable delegate, ErrorHandler errorHandler) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null");
        this.delegate = delegate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void run() {
        try {
            this.delegate.run();
        }
        catch (UndeclaredThrowableException ex) {
            this.errorHandler.handleError(ex.getUndeclaredThrowable());
        }
        catch (Throwable ex) {
            this.errorHandler.handleError(ex);
        }
    }

    public String toString() {
        return "DelegatingErrorHandlingRunnable for " + this.delegate;
    }
}

