/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.support;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.support.CronField;
import java.time.temporal.Temporal;

final class CompositeCronField
extends CronField {
    private final String value;
    private final CronField[] fields;

    private CompositeCronField(CronField.Type type, CronField[] fields, String value) {
        super(type);
        this.value = value;
        this.fields = fields;
    }

    public static CronField compose(CronField[] fields, CronField.Type type, String value) {
        Assert.notEmpty((Object[])fields, (String)"Fields must not be empty");
        Assert.hasLength((String)value, (String)"Value must not be empty");
        if (fields.length == 1) {
            return fields[0];
        }
        return new CompositeCronField(type, fields, value);
    }

    @Override
    @Nullable
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T temporal) {
        Object result = null;
        for (CronField field : this.fields) {
            T candidate = field.nextOrSame(temporal);
            if (result != null && (candidate == null || ((Comparable<Object>)candidate).compareTo(result) >= 0)) continue;
            result = candidate;
        }
        return result;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeCronField)) {
            return false;
        }
        CompositeCronField other = (CompositeCronField)o;
        return this.type() == other.type() && this.value.equals(other.value);
    }

    public String toString() {
        return this.type() + " '" + this.value + "'";
    }
}

