/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.config;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.RuntimeBeanReference;
import cn.taketoday.beans.factory.parsing.BeanComponentDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.support.ManagedList;
import cn.taketoday.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import cn.taketoday.scheduling.support.ScheduledMethodRunnable;
import cn.taketoday.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledTasksBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ELEMENT_SCHEDULED = "scheduled";
    private static final long ZERO_INITIAL_DELAY = 0L;

    protected boolean shouldGenerateId() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return "cn.taketoday.scheduling.config.ContextLifecycleScheduledTaskRegistrar";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(false);
        ManagedList cronTaskList = new ManagedList();
        ManagedList fixedDelayTaskList = new ManagedList();
        ManagedList fixedRateTaskList = new ManagedList();
        ManagedList triggerTaskList = new ManagedList();
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childNodes.item(i);
            if (!this.isScheduledElement(child, parserContext)) continue;
            Element taskElement = (Element)child;
            String ref = taskElement.getAttribute("ref");
            String method = taskElement.getAttribute("method");
            if (StringUtils.isBlank((String)ref) || StringUtils.isBlank((String)method)) {
                parserContext.getReaderContext().error("Both 'ref' and 'method' are required", (Object)taskElement);
                continue;
            }
            String cronAttribute = taskElement.getAttribute("cron");
            String triggerAttribute = taskElement.getAttribute("trigger");
            String fixedRateAttribute = taskElement.getAttribute("fixed-rate");
            String fixedDelayAttribute = taskElement.getAttribute("fixed-delay");
            String initialDelayAttribute = taskElement.getAttribute("initial-delay");
            boolean hasCronAttribute = StringUtils.hasText((String)cronAttribute);
            boolean hasTriggerAttribute = StringUtils.hasText((String)triggerAttribute);
            boolean hasFixedRateAttribute = StringUtils.hasText((String)fixedRateAttribute);
            boolean hasFixedDelayAttribute = StringUtils.hasText((String)fixedDelayAttribute);
            boolean hasInitialDelayAttribute = StringUtils.hasText((String)initialDelayAttribute);
            if (!(hasCronAttribute || hasFixedDelayAttribute || hasFixedRateAttribute || hasTriggerAttribute)) {
                parserContext.getReaderContext().error("one of the 'cron', 'fixed-delay', 'fixed-rate', or 'trigger' attributes is required", (Object)taskElement);
                continue;
            }
            if (hasInitialDelayAttribute && (hasCronAttribute || hasTriggerAttribute)) {
                parserContext.getReaderContext().error("the 'initial-delay' attribute may not be used with cron and trigger tasks", (Object)taskElement);
                continue;
            }
            String runnableName = this.runnableReference(ref, method, taskElement, parserContext).getBeanName();
            if (hasFixedDelayAttribute) {
                fixedDelayTaskList.add((Object)this.intervalTaskReference(runnableName, initialDelayAttribute, fixedDelayAttribute, taskElement, parserContext));
            }
            if (hasFixedRateAttribute) {
                fixedRateTaskList.add((Object)this.intervalTaskReference(runnableName, initialDelayAttribute, fixedRateAttribute, taskElement, parserContext));
            }
            if (hasCronAttribute) {
                cronTaskList.add((Object)this.cronTaskReference(runnableName, cronAttribute, taskElement, parserContext));
            }
            if (!hasTriggerAttribute) continue;
            String triggerName = new RuntimeBeanReference(triggerAttribute).getBeanName();
            triggerTaskList.add((Object)this.triggerTaskReference(runnableName, triggerName, taskElement, parserContext));
        }
        String schedulerRef = element.getAttribute("scheduler");
        if (StringUtils.hasText((String)schedulerRef)) {
            builder.addPropertyReference("taskScheduler", schedulerRef);
        }
        builder.addPropertyValue("cronTasksList", (Object)cronTaskList);
        builder.addPropertyValue("triggerTasksList", (Object)triggerTaskList);
        builder.addPropertyValue("fixedRateTasksList", (Object)fixedRateTaskList);
        builder.addPropertyValue("fixedDelayTasksList", (Object)fixedDelayTaskList);
    }

    private boolean isScheduledElement(Node node, ParserContext parserContext) {
        return node.getNodeType() == 1 && ELEMENT_SCHEDULED.equals(parserContext.getDelegate().getLocalName(node));
    }

    private RuntimeBeanReference runnableReference(String ref, String method, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ScheduledMethodRunnable.class);
        builder.addConstructorArgReference(ref);
        builder.addConstructorArgValue((Object)method);
        return this.beanReference(taskElement, parserContext, builder);
    }

    private RuntimeBeanReference intervalTaskReference(String runnableBeanName, String initialDelay, String interval, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"cn.taketoday.scheduling.config.IntervalTask");
        builder.addConstructorArgReference(runnableBeanName);
        builder.addConstructorArgValue((Object)interval);
        builder.addConstructorArgValue(StringUtils.isNotEmpty((CharSequence)initialDelay) ? initialDelay : Long.valueOf(0L));
        return this.beanReference(taskElement, parserContext, builder);
    }

    private RuntimeBeanReference cronTaskReference(String runnableBeanName, String cronExpression, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"cn.taketoday.scheduling.config.CronTask");
        builder.addConstructorArgReference(runnableBeanName);
        builder.addConstructorArgValue((Object)cronExpression);
        return this.beanReference(taskElement, parserContext, builder);
    }

    private RuntimeBeanReference triggerTaskReference(String runnableBeanName, String triggerBeanName, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"cn.taketoday.scheduling.config.TriggerTask");
        builder.addConstructorArgReference(runnableBeanName);
        builder.addConstructorArgReference(triggerBeanName);
        return this.beanReference(taskElement, parserContext, builder);
    }

    private RuntimeBeanReference beanReference(Element taskElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)taskElement));
        String generatedName = parserContext.getReaderContext().generateBeanName((BeanDefinition)builder.getRawBeanDefinition());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)builder.getBeanDefinition(), generatedName));
        return new RuntimeBeanReference(generatedName);
    }
}

