/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.config;

import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.TaskScheduler;
import cn.taketoday.scheduling.Trigger;
import cn.taketoday.scheduling.concurrent.ConcurrentTaskScheduler;
import cn.taketoday.scheduling.config.CronTask;
import cn.taketoday.scheduling.config.FixedDelayTask;
import cn.taketoday.scheduling.config.FixedRateTask;
import cn.taketoday.scheduling.config.IntervalTask;
import cn.taketoday.scheduling.config.ScheduledTask;
import cn.taketoday.scheduling.config.ScheduledTaskHolder;
import cn.taketoday.scheduling.config.Task;
import cn.taketoday.scheduling.config.TriggerTask;
import cn.taketoday.util.CollectionUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ScheduledTaskRegistrar
implements ScheduledTaskHolder,
InitializingBean,
DisposableBean {
    public static final String CRON_DISABLED = "-";
    @Nullable
    private TaskScheduler taskScheduler;
    @Nullable
    private ScheduledExecutorService localExecutor;
    @Nullable
    private List<TriggerTask> triggerTasks;
    @Nullable
    private List<CronTask> cronTasks;
    @Nullable
    private List<IntervalTask> fixedRateTasks;
    @Nullable
    private List<IntervalTask> fixedDelayTasks;
    private final HashMap<Task, ScheduledTask> unresolvedTasks = new HashMap(16);
    private final LinkedHashSet<ScheduledTask> scheduledTasks = new LinkedHashSet(16);

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    public void setScheduler(@Nullable Object scheduler) {
        if (scheduler == null) {
            this.taskScheduler = null;
        } else if (scheduler instanceof TaskScheduler) {
            this.taskScheduler = (TaskScheduler)scheduler;
        } else if (scheduler instanceof ScheduledExecutorService) {
            this.taskScheduler = new ConcurrentTaskScheduler((ScheduledExecutorService)scheduler);
        } else {
            throw new IllegalArgumentException("Unsupported scheduler type: " + scheduler.getClass());
        }
    }

    @Nullable
    public TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public void setTriggerTasks(Map<Runnable, Trigger> triggerTasks) {
        this.triggerTasks = new ArrayList<TriggerTask>();
        for (Map.Entry<Runnable, Trigger> entry : triggerTasks.entrySet()) {
            this.addTriggerTask(new TriggerTask(entry.getKey(), entry.getValue()));
        }
    }

    public void setTriggerTasksList(List<TriggerTask> triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    public List<TriggerTask> getTriggerTaskList() {
        return this.triggerTasks != null ? Collections.unmodifiableList(this.triggerTasks) : Collections.emptyList();
    }

    public void setCronTasks(Map<Runnable, String> cronTasks) {
        this.cronTasks = new ArrayList<CronTask>();
        for (Map.Entry<Runnable, String> entry : cronTasks.entrySet()) {
            this.addCronTask(entry.getKey(), entry.getValue());
        }
    }

    public void setCronTasksList(List<CronTask> cronTasks) {
        this.cronTasks = cronTasks;
    }

    public List<CronTask> getCronTaskList() {
        return this.cronTasks != null ? Collections.unmodifiableList(this.cronTasks) : Collections.emptyList();
    }

    public void setFixedRateTasks(Map<Runnable, Long> fixedRateTasks) {
        this.fixedRateTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> entry : fixedRateTasks.entrySet()) {
            this.addFixedRateTask(entry.getKey(), entry.getValue());
        }
    }

    public void setFixedRateTasksList(List<IntervalTask> fixedRateTasks) {
        this.fixedRateTasks = fixedRateTasks;
    }

    public List<IntervalTask> getFixedRateTaskList() {
        return this.fixedRateTasks != null ? Collections.unmodifiableList(this.fixedRateTasks) : Collections.emptyList();
    }

    public void setFixedDelayTasks(Map<Runnable, Long> fixedDelayTasks) {
        this.fixedDelayTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> entry : fixedDelayTasks.entrySet()) {
            this.addFixedDelayTask(entry.getKey(), entry.getValue());
        }
    }

    public void setFixedDelayTasksList(List<IntervalTask> fixedDelayTasks) {
        this.fixedDelayTasks = fixedDelayTasks;
    }

    public List<IntervalTask> getFixedDelayTaskList() {
        return this.fixedDelayTasks != null ? Collections.unmodifiableList(this.fixedDelayTasks) : Collections.emptyList();
    }

    public void addTriggerTask(Runnable task, Trigger trigger) {
        this.addTriggerTask(new TriggerTask(task, trigger));
    }

    public void addTriggerTask(TriggerTask task) {
        if (this.triggerTasks == null) {
            this.triggerTasks = new ArrayList<TriggerTask>();
        }
        this.triggerTasks.add(task);
    }

    public void addCronTask(Runnable task, String expression) {
        if (!CRON_DISABLED.equals(expression)) {
            this.addCronTask(new CronTask(task, expression));
        }
    }

    public void addCronTask(CronTask task) {
        if (this.cronTasks == null) {
            this.cronTasks = new ArrayList<CronTask>();
        }
        this.cronTasks.add(task);
    }

    public void addFixedRateTask(Runnable task, long interval) {
        this.addFixedRateTask(new IntervalTask(task, interval, 0L));
    }

    public void addFixedRateTask(Runnable task, Duration interval) {
        this.addFixedRateTask(new IntervalTask(task, interval));
    }

    public void addFixedRateTask(IntervalTask task) {
        if (this.fixedRateTasks == null) {
            this.fixedRateTasks = new ArrayList<IntervalTask>();
        }
        this.fixedRateTasks.add(task);
    }

    public void addFixedDelayTask(Runnable task, long delay) {
        this.addFixedDelayTask(new IntervalTask(task, delay, 0L));
    }

    public void addFixedDelayTask(Runnable task, Duration delay) {
        this.addFixedDelayTask(new IntervalTask(task, delay));
    }

    public void addFixedDelayTask(IntervalTask task) {
        if (this.fixedDelayTasks == null) {
            this.fixedDelayTasks = new ArrayList<IntervalTask>();
        }
        this.fixedDelayTasks.add(task);
    }

    public boolean hasTasks() {
        return CollectionUtils.isNotEmpty(this.triggerTasks) || CollectionUtils.isNotEmpty(this.cronTasks) || CollectionUtils.isNotEmpty(this.fixedRateTasks) || CollectionUtils.isNotEmpty(this.fixedDelayTasks);
    }

    public void afterPropertiesSet() {
        this.scheduleTasks();
    }

    protected void scheduleTasks() {
        if (this.taskScheduler == null) {
            this.localExecutor = Executors.newSingleThreadScheduledExecutor();
            this.taskScheduler = new ConcurrentTaskScheduler(this.localExecutor);
        }
        if (this.triggerTasks != null) {
            for (TriggerTask triggerTask : this.triggerTasks) {
                this.addScheduledTask(this.scheduleTriggerTask(triggerTask));
            }
        }
        if (this.cronTasks != null) {
            for (CronTask cronTask : this.cronTasks) {
                this.addScheduledTask(this.scheduleCronTask(cronTask));
            }
        }
        if (this.fixedRateTasks != null) {
            for (IntervalTask intervalTask : this.fixedRateTasks) {
                if (intervalTask instanceof FixedRateTask) {
                    FixedRateTask fixedRateTask = (FixedRateTask)intervalTask;
                    this.addScheduledTask(this.scheduleFixedRateTask(fixedRateTask));
                    continue;
                }
                this.addScheduledTask(this.scheduleFixedRateTask(new FixedRateTask(intervalTask)));
            }
        }
        if (this.fixedDelayTasks != null) {
            for (IntervalTask intervalTask : this.fixedDelayTasks) {
                if (intervalTask instanceof FixedDelayTask) {
                    FixedDelayTask fixedDelayTask = (FixedDelayTask)intervalTask;
                    this.addScheduledTask(this.scheduleFixedDelayTask(fixedDelayTask));
                    continue;
                }
                this.addScheduledTask(this.scheduleFixedDelayTask(new FixedDelayTask(intervalTask)));
            }
        }
    }

    private void addScheduledTask(@Nullable ScheduledTask task) {
        if (task != null) {
            this.scheduledTasks.add(task);
        }
    }

    @Nullable
    public ScheduledTask scheduleTriggerTask(TriggerTask task) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask(task);
            newTask = true;
        }
        if (this.taskScheduler != null) {
            scheduledTask.future = this.taskScheduler.schedule(task.getRunnable(), task.getTrigger());
        } else {
            this.addTriggerTask(task);
            this.unresolvedTasks.put(task, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    @Nullable
    public ScheduledTask scheduleCronTask(CronTask task) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask(task);
            newTask = true;
        }
        if (this.taskScheduler != null) {
            scheduledTask.future = this.taskScheduler.schedule(task.getRunnable(), task.getTrigger());
        } else {
            this.addCronTask(task);
            this.unresolvedTasks.put(task, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    @Nullable
    public ScheduledTask scheduleFixedRateTask(FixedRateTask task) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask(task);
            newTask = true;
        }
        if (this.taskScheduler != null) {
            Duration initialDelay = task.getInitialDelayDuration();
            if (initialDelay.toMillis() > 0L) {
                Instant startTime = this.taskScheduler.getClock().instant().plus(initialDelay);
                scheduledTask.future = this.taskScheduler.scheduleAtFixedRate(task.getRunnable(), startTime, task.getIntervalDuration());
            } else {
                scheduledTask.future = this.taskScheduler.scheduleAtFixedRate(task.getRunnable(), task.getIntervalDuration());
            }
        } else {
            this.addFixedRateTask(task);
            this.unresolvedTasks.put(task, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    @Nullable
    public ScheduledTask scheduleFixedDelayTask(FixedDelayTask task) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask(task);
            newTask = true;
        }
        if (this.taskScheduler != null) {
            Duration initialDelay = task.getInitialDelayDuration();
            if (!initialDelay.isNegative()) {
                Instant startTime = this.taskScheduler.getClock().instant().plus(task.getInitialDelayDuration());
                scheduledTask.future = this.taskScheduler.scheduleWithFixedDelay(task.getRunnable(), startTime, task.getIntervalDuration());
            } else {
                scheduledTask.future = this.taskScheduler.scheduleWithFixedDelay(task.getRunnable(), task.getIntervalDuration());
            }
        } else {
            this.addFixedDelayTask(task);
            this.unresolvedTasks.put(task, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    @Override
    public Set<ScheduledTask> getScheduledTasks() {
        return Collections.unmodifiableSet(this.scheduledTasks);
    }

    public void destroy() {
        for (ScheduledTask task : this.scheduledTasks) {
            task.cancel();
        }
        if (this.localExecutor != null) {
            this.localExecutor.shutdownNow();
        }
    }
}

