/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.config;

import cn.taketoday.lang.Assert;
import cn.taketoday.scheduling.config.Task;
import java.time.Duration;

public class IntervalTask
extends Task {
    private final Duration interval;
    private final Duration initialDelay;

    public IntervalTask(Runnable runnable, long interval, long initialDelay) {
        this(runnable, Duration.ofMillis(interval), Duration.ofMillis(initialDelay));
    }

    public IntervalTask(Runnable runnable, long interval) {
        this(runnable, Duration.ofMillis(interval), Duration.ZERO);
    }

    public IntervalTask(Runnable runnable, Duration interval) {
        this(runnable, interval, Duration.ZERO);
    }

    public IntervalTask(Runnable runnable, Duration interval, Duration initialDelay) {
        super(runnable);
        Assert.notNull((Object)interval, (String)"Interval is required");
        Assert.notNull((Object)initialDelay, (String)"InitialDelay is required");
        this.interval = interval;
        this.initialDelay = initialDelay;
    }

    IntervalTask(IntervalTask task) {
        super(task.getRunnable());
        Assert.notNull((Object)task, (String)"IntervalTask is required");
        this.interval = task.getIntervalDuration();
        this.initialDelay = task.getInitialDelayDuration();
    }

    public long getInterval() {
        return this.interval.toMillis();
    }

    public Duration getIntervalDuration() {
        return this.interval;
    }

    public long getInitialDelay() {
        return this.initialDelay.toMillis();
    }

    public Duration getInitialDelayDuration() {
        return this.initialDelay;
    }
}

