/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.config;

import cn.taketoday.beans.factory.support.BeanDefinitionBuilder;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import cn.taketoday.util.StringUtils;
import org.w3c.dom.Element;

public class ExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        return "cn.taketoday.scheduling.config.TaskExecutorFactoryBean";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String queueCapacity;
        String keepAliveSeconds = element.getAttribute("keep-alive");
        if (StringUtils.hasText((String)keepAliveSeconds)) {
            builder.addPropertyValue("keepAliveSeconds", (Object)keepAliveSeconds);
        }
        if (StringUtils.hasText((String)(queueCapacity = element.getAttribute("queue-capacity")))) {
            builder.addPropertyValue("queueCapacity", (Object)queueCapacity);
        }
        this.configureRejectionPolicy(element, builder);
        String poolSize = element.getAttribute("pool-size");
        if (StringUtils.hasText((String)poolSize)) {
            builder.addPropertyValue("poolSize", (Object)poolSize);
        }
    }

    private void configureRejectionPolicy(Element element, BeanDefinitionBuilder builder) {
        String rejectionPolicy = element.getAttribute("rejection-policy");
        if (StringUtils.isBlank((String)rejectionPolicy)) {
            return;
        }
        String prefix = "java.util.concurrent.ThreadPoolExecutor.";
        Object policyClassName = switch (rejectionPolicy) {
            case "ABORT" -> prefix + "AbortPolicy";
            case "DISCARD" -> prefix + "DiscardPolicy";
            case "CALLER_RUNS" -> prefix + "CallerRunsPolicy";
            case "DISCARD_OLDEST" -> prefix + "DiscardOldestPolicy";
            default -> rejectionPolicy;
        };
        builder.addPropertyValue("rejectedExecutionHandler", (Object)new RootBeanDefinition((String)policyClassName));
    }
}

