/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.concurrent;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.jndi.JndiLocatorDelegate;
import cn.taketoday.jndi.JndiTemplate;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.scheduling.concurrent.CustomizableThreadFactory;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;

public class DefaultManagedAwareThreadFactory
extends CustomizableThreadFactory
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JndiLocatorDelegate jndiLocator = new JndiLocatorDelegate();
    @Nullable
    private String jndiName = "java:comp/DefaultManagedThreadFactory";
    @Nullable
    private ThreadFactory threadFactory;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiLocator.setJndiTemplate(jndiTemplate);
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiLocator.setJndiEnvironment(jndiEnvironment);
    }

    public void setResourceRef(boolean resourceRef) {
        this.jndiLocator.setResourceRef(resourceRef);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.jndiName != null) {
            try {
                this.threadFactory = this.jndiLocator.lookup(this.jndiName, ThreadFactory.class);
            }
            catch (NamingException ex) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Failed to retrieve [{}] from JNDI", (Object)this.jndiName, (Object)ex);
                }
                this.logger.info("Could not find default managed thread factory in JNDI - proceeding with default local thread factory");
            }
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        if (this.threadFactory != null) {
            return this.threadFactory.newThread(runnable);
        }
        return super.newThread(runnable);
    }
}

