/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.concurrent;

import cn.taketoday.core.task.AsyncListenableTaskExecutor;
import cn.taketoday.core.task.TaskDecorator;
import cn.taketoday.core.task.support.TaskExecutorAdapter;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.SchedulingAwareRunnable;
import cn.taketoday.scheduling.SchedulingTaskExecutor;
import cn.taketoday.scheduling.concurrent.ConcurrentTaskScheduler;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.concurrent.ListenableFuture;
import jakarta.enterprise.concurrent.ManagedExecutors;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ConcurrentTaskExecutor
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor {
    @Nullable
    private static final Class<?> managedExecutorServiceClass = ClassUtils.load((String)"jakarta.enterprise.concurrent.ManagedExecutorService", (ClassLoader)ConcurrentTaskScheduler.class.getClassLoader());
    private Executor concurrentExecutor;
    private TaskExecutorAdapter adaptedExecutor;

    public ConcurrentTaskExecutor() {
        this.concurrentExecutor = Executors.newSingleThreadExecutor();
        this.adaptedExecutor = new TaskExecutorAdapter(this.concurrentExecutor);
    }

    public ConcurrentTaskExecutor(@Nullable Executor executor) {
        this.concurrentExecutor = executor != null ? executor : Executors.newSingleThreadExecutor();
        this.adaptedExecutor = ConcurrentTaskExecutor.getAdaptedExecutor(this.concurrentExecutor);
    }

    public final void setConcurrentExecutor(@Nullable Executor executor) {
        this.concurrentExecutor = executor != null ? executor : Executors.newSingleThreadExecutor();
        this.adaptedExecutor = ConcurrentTaskExecutor.getAdaptedExecutor(this.concurrentExecutor);
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.adaptedExecutor.setTaskDecorator(taskDecorator);
    }

    public void execute(Runnable task) {
        this.adaptedExecutor.execute(task);
    }

    public void execute(Runnable task, long startTimeout) {
        this.adaptedExecutor.execute(task, startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.adaptedExecutor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.adaptedExecutor.submit(task);
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    private static TaskExecutorAdapter getAdaptedExecutor(Executor concurrentExecutor) {
        if (managedExecutorServiceClass != null && managedExecutorServiceClass.isInstance(concurrentExecutor)) {
            return new ManagedTaskExecutorAdapter(concurrentExecutor);
        }
        return new TaskExecutorAdapter(concurrentExecutor);
    }

    private static class ManagedTaskExecutorAdapter
    extends TaskExecutorAdapter {
        public ManagedTaskExecutorAdapter(Executor concurrentExecutor) {
            super(concurrentExecutor);
        }

        public void execute(Runnable task) {
            super.execute(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        public Future<?> submit(Runnable task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        public ListenableFuture<?> submitListenable(Runnable task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }
    }

    protected static class ManagedTaskBuilder {
        protected ManagedTaskBuilder() {
        }

        public static Runnable buildManagedTask(Runnable task, String identityName) {
            HashMap<String, String> properties;
            if (task instanceof SchedulingAwareRunnable) {
                properties = new HashMap<String, String>(4);
                properties.put("jakarta.enterprise.concurrent.LONGRUNNING_HINT", Boolean.toString(((SchedulingAwareRunnable)task).isLongLived()));
            } else {
                properties = new HashMap(2);
            }
            properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask((Runnable)task, properties, null);
        }

        public static <T> Callable<T> buildManagedTask(Callable<T> task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask(task, properties, null);
        }
    }
}

