/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.annotation;

import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.BeanNameAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.NoUniqueBeanDefinitionException;
import cn.taketoday.beans.factory.SmartInitializingSingleton;
import cn.taketoday.beans.factory.config.AutowireCapableBeanFactory;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.DestructionAwareBeanPostProcessor;
import cn.taketoday.beans.factory.config.NamedBeanHolder;
import cn.taketoday.beans.factory.support.MergedBeanDefinitionPostProcessor;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.event.ContextRefreshedEvent;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.MethodIntrospector;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.scheduling.TaskScheduler;
import cn.taketoday.scheduling.annotation.Scheduled;
import cn.taketoday.scheduling.annotation.Schedules;
import cn.taketoday.scheduling.annotation.SchedulingConfigurer;
import cn.taketoday.scheduling.config.CronTask;
import cn.taketoday.scheduling.config.FixedDelayTask;
import cn.taketoday.scheduling.config.FixedRateTask;
import cn.taketoday.scheduling.config.ScheduledTask;
import cn.taketoday.scheduling.config.ScheduledTaskHolder;
import cn.taketoday.scheduling.config.ScheduledTaskRegistrar;
import cn.taketoday.scheduling.support.CronTrigger;
import cn.taketoday.scheduling.support.ScheduledMethodRunnable;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledAnnotationBeanPostProcessor
implements ScheduledTaskHolder,
Ordered,
DestructionAwareBeanPostProcessor,
InitializationBeanPostProcessor,
BeanNameAware,
DisposableBean,
BeanFactoryAware,
ApplicationContextAware,
MergedBeanDefinitionPostProcessor,
EmbeddedValueResolverAware,
SmartInitializingSingleton,
ApplicationListener<ContextRefreshedEvent> {
    public static final String DEFAULT_TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    private static final Logger log = LoggerFactory.getLogger(ScheduledAnnotationBeanPostProcessor.class);
    private final ScheduledTaskRegistrar registrar;
    @Nullable
    private Object scheduler;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    @Nullable
    private String beanName;
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private ApplicationContext applicationContext;
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final IdentityHashMap<Object, Set<ScheduledTask>> scheduledTasks = new IdentityHashMap(16);

    public ScheduledAnnotationBeanPostProcessor() {
        this.registrar = new ScheduledTaskRegistrar();
    }

    public ScheduledAnnotationBeanPostProcessor(ScheduledTaskRegistrar registrar) {
        Assert.notNull((Object)registrar, (String)"ScheduledTaskRegistrar is required");
        this.registrar = registrar;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.beanFactory == null) {
            this.beanFactory = applicationContext;
        }
    }

    public void afterSingletonsInstantiated() {
        this.nonAnnotatedClasses.clear();
        if (this.applicationContext == null) {
            this.finishRegistration();
        }
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getSource() == this.applicationContext) {
            this.finishRegistration();
        }
    }

    private void finishRegistration() {
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        if (this.beanFactory != null) {
            Map beans = this.beanFactory.getBeansOfType(SchedulingConfigurer.class);
            ArrayList configurers = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (SchedulingConfigurer configurer : configurers) {
                configurer.configureTasks(this.registrar);
            }
        }
        if (this.registrar.hasTasks() && this.registrar.getScheduler() == null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find scheduler by type");
            try {
                this.registrar.setTaskScheduler(this.resolveSchedulerBean(this.beanFactory, TaskScheduler.class, false));
            }
            catch (NoUniqueBeanDefinitionException ex) {
                if (log.isTraceEnabled()) {
                    log.trace("Could not find unique TaskScheduler bean - attempting to resolve by name: {}", (Object)ex.getMessage());
                }
                try {
                    this.registrar.setTaskScheduler(this.resolveSchedulerBean(this.beanFactory, TaskScheduler.class, true));
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (log.isInfoEnabled()) {
                        log.info("More than one TaskScheduler bean exists within the context, and none is named 'taskScheduler'. Mark one of them as primary or name it 'taskScheduler' (possibly as an alias); or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback: " + ex.getBeanNamesFound());
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (log.isTraceEnabled()) {
                    log.trace("Could not find default TaskScheduler bean - attempting to find ScheduledExecutorService: {}", (Object)ex.getMessage());
                }
                try {
                    this.registrar.setScheduler(this.resolveSchedulerBean(this.beanFactory, ScheduledExecutorService.class, false));
                }
                catch (NoUniqueBeanDefinitionException ex2) {
                    if (log.isTraceEnabled()) {
                        log.trace("Could not find unique ScheduledExecutorService bean - attempting to resolve by name: {}", (Object)ex2.getMessage());
                    }
                    try {
                        this.registrar.setScheduler(this.resolveSchedulerBean(this.beanFactory, ScheduledExecutorService.class, true));
                    }
                    catch (NoSuchBeanDefinitionException ex3) {
                        if (log.isInfoEnabled()) {
                            log.info("More than one ScheduledExecutorService bean exists within the context, and none is named 'taskScheduler'. Mark one of them as primary or name it 'taskScheduler' (possibly as an alias); or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback: " + ex2.getBeanNamesFound());
                        }
                    }
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (log.isTraceEnabled()) {
                        log.trace("Could not find default ScheduledExecutorService bean - falling back to default: " + ex2.getMessage());
                    }
                    log.info("No TaskScheduler/ScheduledExecutorService bean found for scheduled processing");
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    private <T> T resolveSchedulerBean(BeanFactory beanFactory, Class<T> schedulerType, boolean byName) {
        if (byName) {
            Object scheduler = beanFactory.getBean(DEFAULT_TASK_SCHEDULER_BEAN_NAME, schedulerType);
            if (this.beanName != null && beanFactory instanceof ConfigurableBeanFactory) {
                ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
                cbf.registerDependentBean(DEFAULT_TASK_SCHEDULER_BEAN_NAME, this.beanName);
            }
            return (T)scheduler;
        }
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory abf = (AutowireCapableBeanFactory)beanFactory;
            NamedBeanHolder holder = abf.resolveNamedBean(schedulerType);
            if (this.beanName != null && beanFactory instanceof ConfigurableBeanFactory) {
                ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
                cbf.registerDependentBean(holder.getBeanName(), this.beanName);
            }
            return (T)holder.getBeanInstance();
        }
        return (T)beanFactory.getBean(schedulerType);
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Object bean, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof AopInfrastructureBean || bean instanceof TaskScheduler || bean instanceof ScheduledExecutorService) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass) && AnnotationUtils.isCandidateClass((Class)targetClass, Arrays.asList(Scheduled.class, Schedules.class))) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set scheduledAnnotations = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                return !scheduledAnnotations.isEmpty() ? scheduledAnnotations : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (log.isTraceEnabled()) {
                    log.trace("No @Scheduled annotations found on bean class: {}", (Object)targetClass);
                }
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (Scheduled scheduled : (Set)entry.getValue()) {
                        this.processScheduled(scheduled, method2, bean);
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("{} @Scheduled methods processed on bean '{}': {}", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
                }
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processScheduled(Scheduled scheduled, Method method, Object bean) {
        try {
            String fixedRateString;
            Duration fixedRate;
            String fixedDelayString;
            Duration fixedDelay;
            String cron;
            Runnable runnable = this.createRunnable(bean, method);
            boolean processedSchedule = false;
            String errorMessage = "Exactly one of the 'cron', 'fixedDelay(String)', or 'fixedRate(String)' attributes is required";
            LinkedHashSet<ScheduledTask> tasks = new LinkedHashSet<ScheduledTask>(4);
            Duration initialDelay = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.initialDelay(), scheduled.timeUnit());
            String initialDelayString = scheduled.initialDelayString();
            if (StringUtils.hasText((String)initialDelayString)) {
                Assert.isTrue((boolean)initialDelay.isNegative(), (String)"Specify 'initialDelay' or 'initialDelayString', not both");
                if (this.embeddedValueResolver != null) {
                    initialDelayString = this.embeddedValueResolver.resolveStringValue(initialDelayString);
                }
                if (StringUtils.isNotEmpty((CharSequence)initialDelayString)) {
                    try {
                        initialDelay = ScheduledAnnotationBeanPostProcessor.toDuration(initialDelayString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid initialDelayString value \"" + initialDelayString + "\" - cannot parse into long");
                    }
                }
            }
            if (StringUtils.hasText((String)(cron = scheduled.cron()))) {
                String zone = scheduled.zone();
                if (this.embeddedValueResolver != null) {
                    cron = this.embeddedValueResolver.resolveStringValue(cron);
                    zone = this.embeddedValueResolver.resolveStringValue(zone);
                }
                if (StringUtils.isNotEmpty((CharSequence)cron)) {
                    Assert.isTrue((boolean)initialDelay.isNegative(), (String)"'initialDelay' not supported for cron triggers");
                    processedSchedule = true;
                    if (!"-".equals(cron)) {
                        TimeZone timeZone = StringUtils.hasText((String)zone) ? StringUtils.parseTimeZoneString((String)zone) : TimeZone.getDefault();
                        tasks.add(this.registrar.scheduleCronTask(new CronTask(runnable, new CronTrigger(cron, timeZone))));
                    }
                }
            }
            if (initialDelay.isNegative()) {
                initialDelay = Duration.ZERO;
            }
            if (!(fixedDelay = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.fixedDelay(), scheduled.timeUnit())).isNegative()) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedDelayTask(new FixedDelayTask(runnable, fixedDelay, initialDelay)));
            }
            if (StringUtils.hasText((String)(fixedDelayString = scheduled.fixedDelayString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedDelayString = this.embeddedValueResolver.resolveStringValue(fixedDelayString);
                }
                if (StringUtils.isNotEmpty((CharSequence)fixedDelayString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedDelay = ScheduledAnnotationBeanPostProcessor.toDuration(fixedDelayString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid fixedDelayString value \"" + fixedDelayString + "\" - cannot parse into long");
                    }
                    tasks.add(this.registrar.scheduleFixedDelayTask(new FixedDelayTask(runnable, fixedDelay, initialDelay)));
                }
            }
            if (!(fixedRate = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.fixedRate(), scheduled.timeUnit())).isNegative()) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedRateTask(new FixedRateTask(runnable, fixedRate, initialDelay)));
            }
            if (StringUtils.hasText((String)(fixedRateString = scheduled.fixedRateString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedRateString = this.embeddedValueResolver.resolveStringValue(fixedRateString);
                }
                if (StringUtils.isNotEmpty((CharSequence)fixedRateString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedRate = ScheduledAnnotationBeanPostProcessor.toDuration(fixedRateString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid fixedRateString value \"" + fixedRateString + "\" - cannot parse into long");
                    }
                    tasks.add(this.registrar.scheduleFixedRateTask(new FixedRateTask(runnable, fixedRate, initialDelay)));
                }
            }
            Assert.isTrue((boolean)processedSchedule, (String)errorMessage);
            IdentityHashMap<Object, Set<ScheduledTask>> identityHashMap = this.scheduledTasks;
            synchronized (identityHashMap) {
                Set regTasks = this.scheduledTasks.computeIfAbsent(bean, key -> new LinkedHashSet(4));
                regTasks.addAll(tasks);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Encountered invalid @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
    }

    protected Runnable createRunnable(Object target, Method method) {
        Assert.isTrue((method.getParameterCount() == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled");
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, target.getClass());
        return new ScheduledMethodRunnable(target, invocableMethod);
    }

    private static Duration toDuration(long value, TimeUnit timeUnit) {
        return Duration.of(value, timeUnit.toChronoUnit());
    }

    private static Duration toDuration(String value, TimeUnit timeUnit) {
        if (ScheduledAnnotationBeanPostProcessor.isDurationString(value)) {
            return Duration.parse(value);
        }
        return ScheduledAnnotationBeanPostProcessor.toDuration(Long.parseLong(value), timeUnit);
    }

    private static boolean isDurationString(String value) {
        return value.length() > 1 && (ScheduledAnnotationBeanPostProcessor.isP(value.charAt(0)) || ScheduledAnnotationBeanPostProcessor.isP(value.charAt(1)));
    }

    private static boolean isP(char ch) {
        return ch == 'P' || ch == 'p';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ScheduledTask> getScheduledTasks() {
        LinkedHashSet<ScheduledTask> result = new LinkedHashSet<ScheduledTask>();
        IdentityHashMap<Object, Set<ScheduledTask>> identityHashMap = this.scheduledTasks;
        synchronized (identityHashMap) {
            Collection<Set<ScheduledTask>> allTasks = this.scheduledTasks.values();
            for (Set<ScheduledTask> tasks : allTasks) {
                result.addAll(tasks);
            }
        }
        result.addAll(this.registrar.getScheduledTasks());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeforeDestruction(Object bean, String beanName) {
        Set<ScheduledTask> tasks;
        IdentityHashMap<Object, Set<ScheduledTask>> identityHashMap = this.scheduledTasks;
        synchronized (identityHashMap) {
            tasks = this.scheduledTasks.remove(bean);
        }
        if (tasks != null) {
            for (ScheduledTask task : tasks) {
                task.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresDestruction(Object bean) {
        IdentityHashMap<Object, Set<ScheduledTask>> identityHashMap = this.scheduledTasks;
        synchronized (identityHashMap) {
            return this.scheduledTasks.containsKey(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        IdentityHashMap<Object, Set<ScheduledTask>> identityHashMap = this.scheduledTasks;
        synchronized (identityHashMap) {
            Collection<Set<ScheduledTask>> allTasks = this.scheduledTasks.values();
            for (Set<ScheduledTask> tasks : allTasks) {
                for (ScheduledTask task : tasks) {
                    task.cancel();
                }
            }
            this.scheduledTasks.clear();
        }
        this.registrar.destroy();
    }
}

