/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.annotation;

import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.interceptor.AsyncUncaughtExceptionHandler;
import cn.taketoday.aop.support.AbstractPointcutAdvisor;
import cn.taketoday.aop.support.ComposablePointcut;
import cn.taketoday.aop.support.annotation.AnnotationMatchingPointcut;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.annotation.AnnotationAsyncExecutionInterceptor;
import cn.taketoday.scheduling.annotation.Async;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.function.SingletonSupplier;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;

public class AsyncAnnotationAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private static final long serialVersionUID = 1L;
    private final Advice advice;
    private Pointcut pointcut;

    public AsyncAnnotationAdvisor() {
        this(null, (Supplier<AsyncUncaughtExceptionHandler>)null);
    }

    public AsyncAnnotationAdvisor(@Nullable Executor executor, @Nullable AsyncUncaughtExceptionHandler exceptionHandler) {
        this((Supplier<Executor>)SingletonSupplier.ofNullable((Object)executor), (Supplier<AsyncUncaughtExceptionHandler>)SingletonSupplier.ofNullable((Object)exceptionHandler));
    }

    public AsyncAnnotationAdvisor(@Nullable Supplier<Executor> executor, @Nullable Supplier<AsyncUncaughtExceptionHandler> exceptionHandler) {
        LinkedHashSet<Class<? extends Annotation>> asyncAnnoTypes = new LinkedHashSet<Class<? extends Annotation>>(2);
        asyncAnnoTypes.add(Async.class);
        ClassLoader classLoader = AsyncAnnotationAdvisor.class.getClassLoader();
        try {
            asyncAnnoTypes.add(ClassUtils.forName((String)"jakarta.ejb.Asynchronous", (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            asyncAnnoTypes.add(ClassUtils.forName((String)"jakarta.enterprise.concurrent.Asynchronous", (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.advice = this.buildAdvice(executor, exceptionHandler);
        this.pointcut = this.buildPointcut(asyncAnnoTypes);
    }

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, (String)"'asyncAnnotationType' must not be null");
        this.pointcut = this.buildPointcut(Set.of(asyncAnnotationType));
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Advice advice = this.advice;
        if (advice instanceof BeanFactoryAware) {
            BeanFactoryAware aware = (BeanFactoryAware)advice;
            aware.setBeanFactory(beanFactory);
        }
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    protected Advice buildAdvice(@Nullable Supplier<Executor> executor, @Nullable Supplier<AsyncUncaughtExceptionHandler> exceptionHandler) {
        AnnotationAsyncExecutionInterceptor interceptor = new AnnotationAsyncExecutionInterceptor(null);
        interceptor.configure(executor, exceptionHandler);
        return interceptor;
    }

    protected Pointcut buildPointcut(Set<Class<? extends Annotation>> asyncAnnotationTypes) {
        Pointcut result = null;
        for (Class<? extends Annotation> asyncAnnotationType : asyncAnnotationTypes) {
            AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(asyncAnnotationType, true);
            AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, asyncAnnotationType, true);
            if (result == null) {
                result = new ComposablePointcut((Pointcut)cpc);
            } else {
                result.union((Pointcut)cpc);
            }
            result = result.union((Pointcut)mpc);
        }
        return result != null ? result : Pointcut.TRUE;
    }
}

