/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling.annotation;

import cn.taketoday.aop.interceptor.AsyncUncaughtExceptionHandler;
import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.annotation.DisableDependencyInjection;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ImportAware;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.scheduling.annotation.AsyncConfigurer;
import cn.taketoday.scheduling.annotation.EnableAsync;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.function.SingletonSupplier;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

@DisableDependencyInjection
@Configuration(proxyBeanMethods=false)
public abstract class AbstractAsyncConfiguration
implements ImportAware,
BeanFactoryAware {
    @Nullable
    protected MergedAnnotation<EnableAsync> enableAsync;
    @Nullable
    protected Supplier<Executor> executor;
    @Nullable
    protected Supplier<AsyncUncaughtExceptionHandler> exceptionHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableAsync = importMetadata.getAnnotation(EnableAsync.class);
        if (!this.enableAsync.isPresent()) {
            throw new IllegalArgumentException("@EnableAsync is not present on importing class " + importMetadata.getClassName());
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        SingletonSupplier asyncConfigurer = SingletonSupplier.from(() -> {
            Set configurers = beanFactory.getBeanNamesForType(AsyncConfigurer.class);
            if (ObjectUtils.isEmpty((Object)configurers)) {
                return null;
            }
            if (configurers.size() > 1) {
                throw new IllegalStateException("Only one AsyncConfigurer may exist");
            }
            return (AsyncConfigurer)beanFactory.getBean((String)CollectionUtils.firstElement((Iterable)configurers), AsyncConfigurer.class);
        });
        this.executor = this.adapt((Supplier<AsyncConfigurer>)asyncConfigurer, AsyncConfigurer::getAsyncExecutor);
        this.exceptionHandler = this.adapt((Supplier<AsyncConfigurer>)asyncConfigurer, AsyncConfigurer::getAsyncUncaughtExceptionHandler);
    }

    private <T> Supplier<T> adapt(Supplier<AsyncConfigurer> supplier, Function<AsyncConfigurer, T> provider) {
        return () -> {
            AsyncConfigurer asyncConfigurer = (AsyncConfigurer)supplier.get();
            return asyncConfigurer != null ? provider.apply(asyncConfigurer) : null;
        };
    }
}

