/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.scheduling;

import cn.taketoday.lang.Nullable;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;

public interface TriggerContext {
    default public Clock getClock() {
        return Clock.systemDefaultZone();
    }

    @Nullable
    default public Date lastScheduledExecutionTime() {
        Instant instant = this.lastScheduledExecution();
        return instant != null ? Date.from(instant) : null;
    }

    @Nullable
    public Instant lastScheduledExecution();

    @Nullable
    default public Date lastActualExecutionTime() {
        Instant instant = this.lastActualExecution();
        return instant != null ? Date.from(instant) : null;
    }

    @Nullable
    public Instant lastActualExecution();

    @Nullable
    default public Date lastCompletionTime() {
        Instant instant = this.lastCompletion();
        return instant != null ? Date.from(instant) : null;
    }

    @Nullable
    public Instant lastCompletion();
}

