/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.origin;

import cn.taketoday.core.io.ClassPathResource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.JarUri;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginTrackedResource;
import cn.taketoday.util.ObjectUtils;
import java.io.IOException;
import java.util.Objects;

public class TextResourceOrigin
implements Origin {
    @Nullable
    private final Resource resource;
    @Nullable
    private final Location location;

    public TextResourceOrigin(@Nullable Resource resource, @Nullable Location location) {
        this.resource = resource;
        this.location = location;
    }

    @Nullable
    public Resource getResource() {
        return this.resource;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Origin getParent() {
        return Origin.from(this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TextResourceOrigin) {
            TextResourceOrigin other = (TextResourceOrigin)obj;
            return Objects.equals(this.resource, other.resource) && Objects.equals(this.location, other.location);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.resource);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.location);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getResourceDescription(this.resource));
        if (this.location != null) {
            result.append(" - ").append(this.location);
        }
        return result.toString();
    }

    private String getResourceDescription(@Nullable Resource resource) {
        if (resource instanceof OriginTrackedResource) {
            return this.getResourceDescription(((OriginTrackedResource)resource).getDelegate());
        }
        if (resource == null) {
            return "unknown resource [?]";
        }
        if (resource instanceof ClassPathResource) {
            return this.getResourceDescription((ClassPathResource)resource);
        }
        return resource.toString();
    }

    private String getResourceDescription(ClassPathResource resource) {
        try {
            JarUri jarUri = JarUri.from(resource.getURI());
            if (jarUri != null) {
                return jarUri.getDescription(resource.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource.toString();
    }

    public static final class Location {
        private final int line;
        private final int column;

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            return this.line == other.line && this.column == other.column;
        }

        public int hashCode() {
            return 31 * this.line + this.column;
        }

        public String toString() {
            return this.line + 1 + ":" + (this.column + 1);
        }
    }
}

