/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.origin;

import cn.taketoday.core.env.PropertySource;
import cn.taketoday.lang.Assert;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginLookup;

public class PropertySourceOrigin
implements Origin {
    private final PropertySource<?> propertySource;
    private final String propertyName;

    public PropertySourceOrigin(PropertySource<?> propertySource, String propertyName) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null");
        Assert.hasLength((String)propertyName, (String)"PropertyName must not be empty");
        this.propertySource = propertySource;
        this.propertyName = propertyName;
    }

    public PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return "\"" + this.propertyName + "\" from property source \"" + this.propertySource.getName() + "\"";
    }

    public static Origin get(PropertySource<?> propertySource, String name) {
        Origin origin = OriginLookup.getOrigin(propertySource, name);
        return origin != null ? origin : new PropertySourceOrigin(propertySource, name);
    }
}

