/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.origin;

import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginProvider;
import cn.taketoday.util.ObjectUtils;

public class OriginTrackedValue
implements OriginProvider {
    private final Object value;
    @Nullable
    private final Origin origin;

    private OriginTrackedValue(Object value, @Nullable Origin origin) {
        this.value = value;
        this.origin = origin;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)((OriginTrackedValue)obj).value);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value);
    }

    @Nullable
    public String toString() {
        return this.value.toString();
    }

    @Nullable
    public static OriginTrackedValue of(Object value) {
        return OriginTrackedValue.of(value, null);
    }

    @Nullable
    public static OriginTrackedValue of(@Nullable Object value, @Nullable Origin origin) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return new OriginTrackedCharSequence((CharSequence)value, origin);
        }
        return new OriginTrackedValue(value, origin);
    }

    private static class OriginTrackedCharSequence
    extends OriginTrackedValue
    implements CharSequence {
        OriginTrackedCharSequence(CharSequence value, @Nullable Origin origin) {
            super(value, origin);
        }

        @Override
        public int length() {
            return this.getValue().length();
        }

        @Override
        public char charAt(int index) {
            return this.getValue().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.getValue().subSequence(start, end);
        }

        @Override
        public CharSequence getValue() {
            return (CharSequence)super.getValue();
        }
    }
}

