/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.origin;

import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceDecorator;
import cn.taketoday.core.io.WritableResource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.Origin;
import cn.taketoday.origin.OriginProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class OriginTrackedResource
extends ResourceDecorator
implements Resource,
OriginProvider {
    @Nullable
    private final Origin origin;

    OriginTrackedResource(Resource resource, @Nullable Origin origin) {
        super(resource);
        this.origin = origin;
    }

    @Override
    @Nullable
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OriginTrackedResource other = (OriginTrackedResource)obj;
        return this.delegate.equals(other.delegate) && Objects.equals(this.origin, other.origin);
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + Objects.hashCode(this.origin);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static OriginTrackedWritableResource from(WritableResource resource, @Nullable Origin origin) {
        return new OriginTrackedWritableResource(resource, origin);
    }

    public static OriginTrackedResource from(Resource resource, @Nullable Origin origin) {
        if (resource instanceof WritableResource) {
            return new OriginTrackedWritableResource((WritableResource)resource, origin);
        }
        return new OriginTrackedResource(resource, origin);
    }

    public static class OriginTrackedWritableResource
    extends OriginTrackedResource
    implements WritableResource {
        OriginTrackedWritableResource(WritableResource resource, @Nullable Origin origin) {
            super((Resource)resource, origin);
        }

        public WritableResource getDelegate() {
            return (WritableResource)super.getDelegate();
        }

        public boolean isWritable() {
            return this.getDelegate().isWritable();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.getDelegate().getOutputStream();
        }

        public WritableByteChannel writableChannel() throws IOException {
            return this.getDelegate().writableChannel();
        }

        public Writer getWriter() throws IOException {
            return this.getDelegate().getWriter();
        }
    }
}

