/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.origin;

import cn.taketoday.lang.Nullable;
import cn.taketoday.origin.OriginProvider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public interface Origin {
    @Nullable
    default public Origin getParent() {
        return null;
    }

    @Nullable
    public static Origin from(@Nullable Object source) {
        if (source instanceof Origin) {
            return (Origin)source;
        }
        Origin origin = null;
        if (source instanceof OriginProvider) {
            origin = ((OriginProvider)source).getOrigin();
        }
        if (origin == null && source instanceof Throwable) {
            return Origin.from(((Throwable)source).getCause());
        }
        return origin;
    }

    public static List<Origin> parentsFrom(@Nullable Object source) {
        Origin origin = Origin.from(source);
        if (origin == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<Origin> parents = new LinkedHashSet<Origin>();
        for (origin = origin.getParent(); origin != null && !parents.contains(origin); origin = origin.getParent()) {
            parents.add(origin);
        }
        return List.copyOf(parents);
    }
}

