/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jndi.support;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanNotOfRequiredTypeException;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.ObjectProvider;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.support.DependencyInjector;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.jndi.JndiLocatorSupport;
import cn.taketoday.jndi.TypeMismatchNamingException;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class SimpleJndiBeanFactory
extends JndiLocatorSupport
implements BeanFactory {
    private final Set<String> shareableResources = new HashSet<String>();
    private final Map<String, Object> singletonObjects = new HashMap<String, Object>();
    private final Map<String, Class<?>> resourceTypes = new HashMap();
    @Nullable
    private DependencyInjector dependencyInjector;

    public SimpleJndiBeanFactory() {
        this.setResourceRef(true);
    }

    public void addShareableResource(String shareableResource) {
        this.shareableResources.add(shareableResource);
    }

    public void setShareableResources(String ... shareableResources) {
        Collections.addAll(this.shareableResources, shareableResources);
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, Object.class);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        try {
            if (this.isSingleton(name)) {
                return this.doGetSingleton(name, requiredType);
            }
            return this.lookup(name, requiredType);
        }
        catch (NameNotFoundException ex) {
            throw new NoSuchBeanDefinitionException(name, "not found in JNDI environment");
        }
        catch (TypeMismatchNamingException ex) {
            throw new BeanNotOfRequiredTypeException(name, ex.getRequiredType(), ex.getActualType());
        }
        catch (NamingException ex) {
            throw new BeanDefinitionStoreException("JNDI environment", name, "JNDI lookup failed", (Throwable)ex);
        }
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(name);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType.getSimpleName(), requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(final Class<T> requiredType) {
        return new ObjectProvider<T>(){

            public T get() throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType);
            }

            public T get(Object ... args) throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType, args);
            }

            @Nullable
            public T getIfAvailable() throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType);
            }

            @Nullable
            public T getIfUnique() throws BeansException {
                return SimpleJndiBeanFactory.this.getBean(requiredType);
            }
        };
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support resolution by ResolvableType");
    }

    public boolean containsBean(String name) {
        if (this.singletonObjects.containsKey(name) || this.resourceTypes.containsKey(name)) {
            return true;
        }
        try {
            this.doGetType(name);
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.shareableResources.contains(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return !this.shareableResources.contains(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type = this.getType(name);
        return type != null && typeToMatch.isAssignableFrom(type);
    }

    public boolean isTypeMatch(String name, @Nullable Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type = this.getType(name);
        return typeToMatch == null || type != null && typeToMatch.isAssignableFrom(type);
    }

    @Nullable
    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.getType(name, true);
    }

    @Nullable
    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        try {
            return this.doGetType(name);
        }
        catch (NameNotFoundException ex) {
            throw new NoSuchBeanDefinitionException(name, "not found in JNDI environment");
        }
        catch (NamingException ex) {
            return null;
        }
    }

    public String[] getAliases(String name) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetSingleton(String name, @Nullable Class<T> requiredType) throws NamingException {
        Map<String, Object> map = this.singletonObjects;
        synchronized (map) {
            Object singleton = this.singletonObjects.get(name);
            if (singleton != null) {
                if (requiredType != null && !requiredType.isInstance(singleton)) {
                    throw new TypeMismatchNamingException(this.convertJndiName(name), requiredType, singleton.getClass());
                }
                return (T)singleton;
            }
            T jndiObject = this.lookup(name, requiredType);
            this.singletonObjects.put(name, jndiObject);
            return jndiObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> doGetType(String name) throws NamingException {
        if (this.isSingleton(name)) {
            return this.doGetSingleton(name, null).getClass();
        }
        Map<String, Class<?>> map = this.resourceTypes;
        synchronized (map) {
            Class<?> type = this.resourceTypes.get(name);
            if (type == null) {
                type = this.lookup(name, null).getClass();
                this.resourceTypes.put(name, type);
            }
            return type;
        }
    }

    @Nullable
    public <A extends Annotation> A findSynthesizedAnnotation(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support findSynthesizedAnnotation");
    }

    public <A extends Annotation> MergedAnnotation<A> findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support findAnnotationOnBean");
    }

    public <A extends Annotation> MergedAnnotation<A> findAnnotationOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support findAnnotationOnBean");
    }

    public boolean containsBeanDefinition(String beanName) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support containsBeanDefinition");
    }

    @Nullable
    public BeanDefinition getBeanDefinition(String beanName) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanDefinition");
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType, boolean includeNonSingletons) throws BeansException {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeansWithAnnotation");
    }

    public <T> Map<String, T> getBeansOfType(ResolvableType requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeansOfType");
    }

    public Set<String> getBeanNamesForType(Class<?> requiredType, boolean includeNonSingletons) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanNamesForType");
    }

    public Set<String> getBeanNamesForType(ResolvableType type) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanNamesForType");
    }

    public Set<String> getBeanNamesForType(ResolvableType requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanNamesForType");
    }

    public Set<String> getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanNamesForAnnotation");
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getObjectProvider");
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType, boolean allowEagerInit) {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getObjectProvider");
    }

    public int getBeanDefinitionCount() {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanDefinitionCount");
    }

    public String[] getBeanDefinitionNames() {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanDefinitionNames");
    }

    public Map<String, BeanDefinition> getBeanDefinitions() {
        throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support getBeanDefinitions");
    }

    public DependencyInjector getInjector() {
        if (this.dependencyInjector == null) {
            this.dependencyInjector = new DependencyInjector((BeanFactory)this);
        }
        return this.dependencyInjector;
    }
}

