/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jndi;

import cn.taketoday.core.env.PropertySource;
import cn.taketoday.jndi.JndiLocatorDelegate;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import javax.naming.NamingException;

public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    private static final Logger log = LoggerFactory.getLogger(JndiPropertySource.class);

    public JndiPropertySource(String name) {
        this(name, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name, JndiLocatorDelegate jndiLocator) {
        super(name, (Object)jndiLocator);
    }

    @Nullable
    public Object getProperty(String name) {
        if (((JndiLocatorDelegate)this.getSource()).isResourceRef() && name.indexOf(58) != -1) {
            return null;
        }
        try {
            Object value = ((JndiLocatorDelegate)this.source).lookup(name);
            if (log.isDebugEnabled()) {
                log.debug("JNDI lookup for name [{}] returned: [{}]", (Object)name, value);
            }
            return value;
        }
        catch (NamingException ex) {
            if (log.isDebugEnabled()) {
                log.debug("JNDI lookup for name [{}] threw NamingException with message: {}. Returning null.", (Object)name, (Object)ex.getMessage());
            }
            return null;
        }
    }
}

