/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jndi;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.jndi.JndiLocatorSupport;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import javax.naming.NamingException;

public abstract class JndiObjectLocator
extends JndiLocatorSupport
implements InitializingBean {
    @Nullable
    private String jndiName;
    @Nullable
    private Class<?> expectedType;

    public void setJndiName(@Nullable String jndiName) {
        this.jndiName = jndiName;
    }

    @Nullable
    public String getJndiName() {
        return this.jndiName;
    }

    public void setExpectedType(@Nullable Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    @Nullable
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        if (StringUtils.isEmpty((CharSequence)this.getJndiName())) {
            throw new IllegalArgumentException("Property 'jndiName' is required");
        }
    }

    protected Object lookup() throws NamingException {
        String jndiName = this.getJndiName();
        Assert.state((jndiName != null ? 1 : 0) != 0, (String)"No JNDI name specified");
        return this.lookup(jndiName, this.getExpectedType());
    }
}

