/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jndi;

import cn.taketoday.jndi.JndiAccessor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import javax.naming.NamingException;

public abstract class JndiLocatorSupport
extends JndiAccessor {
    public static final String CONTAINER_PREFIX = "java:comp/env/";
    private boolean resourceRef = false;

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String jndiName) throws NamingException {
        return this.lookup(jndiName, null);
    }

    protected <T> T lookup(String jndiName, @Nullable Class<T> requiredType) throws NamingException {
        T jndiObject;
        Assert.notNull((Object)jndiName, (String)"'jndiName' must not be null");
        String convertedName = this.convertJndiName(jndiName);
        try {
            jndiObject = this.getJndiTemplate().lookup(convertedName, requiredType);
        }
        catch (NamingException ex) {
            if (!convertedName.equals(jndiName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Converted JNDI name [{}] not found - trying original name [{}]. ", new Object[]{convertedName, jndiName, ex});
                }
                jndiObject = this.getJndiTemplate().lookup(jndiName, requiredType);
            }
            throw ex;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Located object with JNDI name [{}]", (Object)convertedName);
        }
        return jndiObject;
    }

    protected String convertJndiName(String jndiName) {
        if (this.isResourceRef() && !((String)jndiName).startsWith(CONTAINER_PREFIX) && ((String)jndiName).indexOf(58) == -1) {
            jndiName = CONTAINER_PREFIX + (String)jndiName;
        }
        return jndiName;
    }
}

