/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.support;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.aop.target.AbstractLazyCreationTargetSource;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanServerConnectionFactoryBean
implements FactoryBean<MBeanServerConnection>,
BeanClassLoaderAware,
InitializingBean,
DisposableBean {
    @Nullable
    private JMXServiceURL serviceUrl;
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private boolean connectOnStartup = true;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private JMXConnector connector;
    @Nullable
    private MBeanServerConnection connection;
    @Nullable
    private JMXConnectorLazyInitTargetSource connectorTargetSource;

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setEnvironment(Properties environment) {
        CollectionUtils.mergePropertiesIntoMap((Properties)environment, this.environment);
    }

    public void setEnvironmentMap(@Nullable Map<String, ?> environment) {
        if (environment != null) {
            this.environment.putAll(environment);
        }
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.serviceUrl == null) {
            throw new IllegalArgumentException("Property 'serviceUrl' is required");
        }
        if (this.connectOnStartup) {
            this.connect();
        } else {
            this.createLazyConnection();
        }
    }

    private void connect() throws IOException {
        Assert.state((this.serviceUrl != null ? 1 : 0) != 0, (String)"No JMXServiceURL set");
        this.connector = JMXConnectorFactory.connect(this.serviceUrl, this.environment);
        this.connection = this.connector.getMBeanServerConnection();
    }

    private void createLazyConnection() {
        this.connectorTargetSource = new JMXConnectorLazyInitTargetSource();
        MBeanServerConnectionLazyInitTargetSource connectionTargetSource = new MBeanServerConnectionLazyInitTargetSource();
        this.connector = (JMXConnector)new ProxyFactory(JMXConnector.class, (TargetSource)this.connectorTargetSource).getProxy(this.beanClassLoader);
        this.connection = (MBeanServerConnection)new ProxyFactory(MBeanServerConnection.class, (TargetSource)connectionTargetSource).getProxy(this.beanClassLoader);
    }

    @Nullable
    public MBeanServerConnection getObject() {
        return this.connection;
    }

    public Class<? extends MBeanServerConnection> getObjectType() {
        return this.connection != null ? this.connection.getClass() : MBeanServerConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws IOException {
        if (this.connector != null && (this.connectorTargetSource == null || this.connectorTargetSource.isInitialized())) {
            this.connector.close();
        }
    }

    private class JMXConnectorLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private JMXConnectorLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            Assert.state((MBeanServerConnectionFactoryBean.this.serviceUrl != null ? 1 : 0) != 0, (String)"No JMXServiceURL set");
            return JMXConnectorFactory.connect(MBeanServerConnectionFactoryBean.this.serviceUrl, MBeanServerConnectionFactoryBean.this.environment);
        }

        public Class<?> getTargetClass() {
            return JMXConnector.class;
        }
    }

    private class MBeanServerConnectionLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private MBeanServerConnectionLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            Assert.state((MBeanServerConnectionFactoryBean.this.connector != null ? 1 : 0) != 0, (String)"JMXConnector not initialized");
            return MBeanServerConnectionFactoryBean.this.connector.getMBeanServerConnection();
        }

        public Class<?> getTargetClass() {
            return MBeanServerConnection.class;
        }
    }
}

