/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.export.naming;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.jmx.export.metadata.JmxAttributeSource;
import cn.taketoday.jmx.export.metadata.ManagedResource;
import cn.taketoday.jmx.export.naming.ObjectNamingStrategy;
import cn.taketoday.jmx.support.ObjectNameManager;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MetadataNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    @Nullable
    private JmxAttributeSource attributeSource;
    @Nullable
    private String defaultDomain;

    public MetadataNamingStrategy() {
    }

    public MetadataNamingStrategy(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("Property 'attributeSource' is required");
        }
    }

    @Override
    public ObjectName getObjectName(Object managedBean, @Nullable String beanKey) throws MalformedObjectNameException {
        Assert.state((this.attributeSource != null ? 1 : 0) != 0, (String)"No JmxAttributeSource set");
        Class managedClass = AopUtils.getTargetClass((Object)managedBean);
        ManagedResource mr = this.attributeSource.getManagedResource(managedClass);
        if (mr != null && StringUtils.hasText((String)mr.getObjectName())) {
            return ObjectNameManager.getInstance(mr.getObjectName());
        }
        Assert.state((beanKey != null ? 1 : 0) != 0, (String)"No ManagedResource attribute and no bean key specified");
        try {
            return ObjectNameManager.getInstance(beanKey);
        }
        catch (MalformedObjectNameException ex) {
            String domain = this.defaultDomain;
            if (domain == null) {
                domain = ClassUtils.getPackageName((Class)managedClass);
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("type", ClassUtils.getShortName((Class)managedClass));
            properties.put("name", beanKey);
            return ObjectNameManager.getInstance(domain, properties);
        }
    }
}

