/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.export.naming;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.core.io.PropertiesUtils;
import cn.taketoday.core.io.Resource;
import cn.taketoday.jmx.export.naming.ObjectNamingStrategy;
import cn.taketoday.jmx.support.ObjectNameManager;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class KeyNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Properties mappings;
    @Nullable
    private Resource[] mappingLocations;
    @Nullable
    private Properties mergedMappings;

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void setMappingLocation(Resource location) {
        this.mappingLocations = new Resource[]{location};
    }

    public void setMappingLocations(Resource ... mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void afterPropertiesSet() throws IOException {
        this.mergedMappings = new Properties();
        CollectionUtils.mergePropertiesIntoMap((Properties)this.mappings, (Map)this.mergedMappings);
        if (this.mappingLocations != null) {
            boolean debugEnabled = this.logger.isDebugEnabled();
            for (Resource location : this.mappingLocations) {
                if (debugEnabled) {
                    this.logger.debug("Loading JMX object name mappings file from {}", (Object)location);
                }
                PropertiesUtils.fillProperties((Properties)this.mergedMappings, (Resource)location);
            }
        }
    }

    @Override
    public ObjectName getObjectName(Object managedBean, @Nullable String beanKey) throws MalformedObjectNameException {
        Assert.notNull((Object)beanKey, (String)"KeyNamingStrategy requires bean key");
        String objectName = null;
        if (this.mergedMappings != null) {
            objectName = this.mergedMappings.getProperty(beanKey);
        }
        if (objectName == null) {
            objectName = beanKey;
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

