/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.export.assembler;

import cn.taketoday.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import cn.taketoday.jmx.export.metadata.JmxMetadataUtils;
import cn.taketoday.jmx.export.metadata.ManagedNotification;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.modelmbean.ModelMBeanNotificationInfo;

public abstract class AbstractConfigurableMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler {
    @Nullable
    private ModelMBeanNotificationInfo[] notificationInfos;
    private final Map<String, ModelMBeanNotificationInfo[]> notificationInfoMappings = new HashMap<String, ModelMBeanNotificationInfo[]>();

    public void setNotificationInfos(ManagedNotification[] notificationInfos) {
        ModelMBeanNotificationInfo[] infos = new ModelMBeanNotificationInfo[notificationInfos.length];
        for (int i = 0; i < notificationInfos.length; ++i) {
            ManagedNotification notificationInfo = notificationInfos[i];
            infos[i] = JmxMetadataUtils.convertToModelMBeanNotificationInfo(notificationInfo);
        }
        this.notificationInfos = infos;
    }

    public void setNotificationInfoMappings(Map<String, Object> notificationInfoMappings) {
        notificationInfoMappings.forEach((beanKey, result) -> this.notificationInfoMappings.put((String)beanKey, this.extractNotificationMetadata(result)));
    }

    @Override
    protected ModelMBeanNotificationInfo[] getNotificationInfo(Object managedBean, String beanKey) {
        ModelMBeanNotificationInfo[] result = null;
        if (StringUtils.hasText((String)beanKey)) {
            result = this.notificationInfoMappings.get(beanKey);
        }
        if (result == null) {
            result = this.notificationInfos;
        }
        return result != null ? result : new ModelMBeanNotificationInfo[]{};
    }

    private ModelMBeanNotificationInfo[] extractNotificationMetadata(Object mapValue) {
        if (mapValue instanceof ManagedNotification) {
            ManagedNotification mn = (ManagedNotification)mapValue;
            return new ModelMBeanNotificationInfo[]{JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn)};
        }
        if (mapValue instanceof Collection) {
            Collection col = (Collection)mapValue;
            ArrayList<ModelMBeanNotificationInfo> result = new ArrayList<ModelMBeanNotificationInfo>();
            for (Object colValue : col) {
                if (!(colValue instanceof ManagedNotification)) {
                    throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
                }
                ManagedNotification mn = (ManagedNotification)colValue;
                result.add(JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn));
            }
            return result.toArray(new ModelMBeanNotificationInfo[0]);
        }
        throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
    }
}

