/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.export.annotation;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.BeanWrapper;
import cn.taketoday.beans.PropertyValue;
import cn.taketoday.beans.PropertyValues;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.EmbeddedValueResolver;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotationPredicates;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.RepeatableContainers;
import cn.taketoday.jmx.export.annotation.ManagedAttribute;
import cn.taketoday.jmx.export.annotation.ManagedMetric;
import cn.taketoday.jmx.export.annotation.ManagedNotification;
import cn.taketoday.jmx.export.annotation.ManagedNotifications;
import cn.taketoday.jmx.export.annotation.ManagedOperation;
import cn.taketoday.jmx.export.annotation.ManagedOperationParameter;
import cn.taketoday.jmx.export.annotation.ManagedOperationParameters;
import cn.taketoday.jmx.export.annotation.ManagedResource;
import cn.taketoday.jmx.export.metadata.InvalidMetadataException;
import cn.taketoday.jmx.export.metadata.JmxAttributeSource;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource,
BeanFactoryAware {
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    @Override
    @Nullable
    public cn.taketoday.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        Class target;
        MergedAnnotation ann = MergedAnnotations.from(beanClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ManagedResource.class).withNonMergedAttributes();
        if (!ann.isPresent()) {
            return null;
        }
        Class declaringClass = (Class)ann.getSource();
        Class clazz = target = declaringClass != null && !declaringClass.isInterface() ? declaringClass : beanClass;
        if (!Modifier.isPublic(target.getModifiers())) {
            throw new InvalidMetadataException("@ManagedResource class '" + target.getName() + "' must be public");
        }
        cn.taketoday.jmx.export.metadata.ManagedResource bean = new cn.taketoday.jmx.export.metadata.ManagedResource();
        Map map = ann.asMap(new MergedAnnotation.Adapt[0]);
        ArrayList list = new ArrayList(map.size());
        map.forEach((attrName, attrValue) -> {
            if (!"value".equals(attrName)) {
                Object value = attrValue;
                if (this.embeddedValueResolver != null && value instanceof String) {
                    value = this.embeddedValueResolver.resolveStringValue((String)value);
                }
                list.add(new PropertyValue(attrName, value));
            }
        });
        BeanWrapper.forBeanPropertyAccess((Object)bean).setPropertyValues(new PropertyValues(list));
        return bean;
    }

    @Override
    @Nullable
    public cn.taketoday.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        MergedAnnotation ann = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ManagedAttribute.class).withNonMergedAttributes();
        if (!ann.isPresent()) {
            return null;
        }
        cn.taketoday.jmx.export.metadata.ManagedAttribute bean = new cn.taketoday.jmx.export.metadata.ManagedAttribute();
        Map map = ann.asMap(new MergedAnnotation.Adapt[0]);
        PropertyValues pvs = new PropertyValues(map);
        pvs.remove("defaultValue");
        BeanWrapper.forBeanPropertyAccess((Object)bean).setPropertyValues(pvs);
        String defaultValue = (String)map.get("defaultValue");
        if (defaultValue.length() > 0) {
            bean.setDefaultValue(defaultValue);
        }
        return bean;
    }

    @Override
    @Nullable
    public cn.taketoday.jmx.export.metadata.ManagedMetric getManagedMetric(Method method) throws InvalidMetadataException {
        MergedAnnotation ann = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ManagedMetric.class).withNonMergedAttributes();
        return AnnotationJmxAttributeSource.copyPropertiesToBean((MergedAnnotation<? extends Annotation>)ann, cn.taketoday.jmx.export.metadata.ManagedMetric.class);
    }

    @Override
    @Nullable
    public cn.taketoday.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        MergedAnnotation ann = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ManagedOperation.class).withNonMergedAttributes();
        return AnnotationJmxAttributeSource.copyPropertiesToBean((MergedAnnotation<? extends Annotation>)ann, cn.taketoday.jmx.export.metadata.ManagedOperation.class);
    }

    @Override
    public cn.taketoday.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        List<MergedAnnotation<? extends Annotation>> anns = AnnotationJmxAttributeSource.getRepeatableAnnotations(method, ManagedOperationParameter.class, ManagedOperationParameters.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBeanArray(anns, cn.taketoday.jmx.export.metadata.ManagedOperationParameter.class);
    }

    @Override
    public cn.taketoday.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class<?> clazz) throws InvalidMetadataException {
        List<MergedAnnotation<? extends Annotation>> anns = AnnotationJmxAttributeSource.getRepeatableAnnotations(clazz, ManagedNotification.class, ManagedNotifications.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBeanArray(anns, cn.taketoday.jmx.export.metadata.ManagedNotification.class);
    }

    private static List<MergedAnnotation<? extends Annotation>> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, Class<? extends Annotation> containerAnnotationType) {
        return MergedAnnotations.from((AnnotatedElement)annotatedElement, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.valueOf(annotationType, containerAnnotationType)).stream(annotationType).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(MergedAnnotation::withNonMergedAttributes).collect(Collectors.toList());
    }

    private static <T> T[] copyPropertiesToBeanArray(List<MergedAnnotation<? extends Annotation>> anns, Class<T> beanClass) {
        Object[] beans = (Object[])Array.newInstance(beanClass, anns.size());
        int i = 0;
        for (MergedAnnotation<? extends Annotation> ann : anns) {
            beans[i++] = AnnotationJmxAttributeSource.copyPropertiesToBean(ann, beanClass);
        }
        return beans;
    }

    @Nullable
    private static <T> T copyPropertiesToBean(MergedAnnotation<? extends Annotation> ann, Class<T> beanClass) {
        if (!ann.isPresent()) {
            return null;
        }
        Object bean = BeanUtils.newInstance(beanClass);
        BeanWrapper bw = BeanWrapper.forBeanPropertyAccess((Object)bean);
        bw.setPropertyValues(new PropertyValues(ann.asMap(new MergedAnnotation.Adapt[0])));
        return (T)bean;
    }
}

