/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.access;

import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.jmx.MBeanServerNotFoundException;
import cn.taketoday.jmx.access.MBeanClientInterceptor;
import cn.taketoday.jmx.access.MBeanInfoRetrievalException;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import org.aopalliance.intercept.Interceptor;

public class MBeanProxyFactoryBean
extends MBeanClientInterceptor
implements FactoryBean<Object>,
BeanClassLoaderAware,
InitializingBean {
    @Nullable
    private Class<?> proxyInterface;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private Object mbeanProxy;

    public void setProxyInterface(Class<?> proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        super.afterPropertiesSet();
        if (this.proxyInterface == null) {
            this.proxyInterface = this.getManagementInterface();
            if (this.proxyInterface == null) {
                throw new IllegalArgumentException("Property 'proxyInterface' or 'managementInterface' is required");
            }
        } else if (this.getManagementInterface() == null) {
            this.setManagementInterface(this.proxyInterface);
        }
        this.mbeanProxy = new ProxyFactory(this.proxyInterface, (Interceptor)this).getProxy(this.beanClassLoader);
    }

    @Nullable
    public Object getObject() {
        return this.mbeanProxy;
    }

    public Class<?> getObjectType() {
        return this.proxyInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

