/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.jmx.access;

import cn.taketoday.jmx.MBeanServerNotFoundException;
import cn.taketoday.jmx.support.JmxUtils;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class ConnectorDelegate {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorDelegate.class);
    @Nullable
    private JMXConnector connector;

    ConnectorDelegate() {
    }

    public MBeanServerConnection connect(@Nullable JMXServiceURL serviceUrl, @Nullable Map<String, ?> environment, @Nullable String agentId) throws MBeanServerNotFoundException {
        if (serviceUrl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting to remote MBeanServer at URL [{}]", (Object)serviceUrl);
            }
            try {
                this.connector = JMXConnectorFactory.connect(serviceUrl, environment);
                return this.connector.getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer [" + serviceUrl + "]", ex);
            }
        }
        logger.debug("Attempting to locate local MBeanServer");
        return JmxUtils.locateMBeanServer(agentId);
    }

    public void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException ex) {
                logger.debug("Could not close JMX connector", (Throwable)ex);
            }
        }
    }
}

