/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.instrument;

import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.instrument.SimpleInstrumentableClassLoader;
import cn.taketoday.instrument.SimpleThrowawayClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class SimpleLoadTimeWeaver
implements LoadTimeWeaver {
    private final SimpleInstrumentableClassLoader classLoader;

    public SimpleLoadTimeWeaver() {
        this.classLoader = new SimpleInstrumentableClassLoader(ClassUtils.getDefaultClassLoader());
    }

    public SimpleLoadTimeWeaver(SimpleInstrumentableClassLoader classLoader) {
        Assert.notNull((Object)((Object)classLoader), (String)"ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

