/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.instrument;

import cn.taketoday.core.DecoratingClassLoader;
import cn.taketoday.core.OverridingClassLoader;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.instrument.SimpleThrowawayClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;

public class ReflectiveLoadTimeWeaver
implements LoadTimeWeaver {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveLoadTimeWeaver.class);
    private static final String ADD_TRANSFORMER_METHOD_NAME = "addTransformer";
    private static final String GET_THROWAWAY_CLASS_LOADER_METHOD_NAME = "getThrowawayClassLoader";
    private final ClassLoader classLoader;
    private final Method addTransformerMethod;
    @Nullable
    private final Method getThrowawayClassLoaderMethod;

    public ReflectiveLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public ReflectiveLoadTimeWeaver(@Nullable ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.classLoader = classLoader;
        Method addTransformerMethod = ReflectionUtils.getMethodIfAvailable(this.classLoader.getClass(), (String)ADD_TRANSFORMER_METHOD_NAME, (Class[])new Class[]{ClassFileTransformer.class});
        if (addTransformerMethod == null) {
            throw new IllegalStateException("ClassLoader [" + classLoader.getClass().getName() + "] does NOT provide an 'addTransformer(ClassFileTransformer)' method.");
        }
        this.addTransformerMethod = addTransformerMethod;
        Method getThrowawayClassLoaderMethod = ReflectionUtils.getMethodIfAvailable(this.classLoader.getClass(), (String)GET_THROWAWAY_CLASS_LOADER_METHOD_NAME, (Class[])new Class[0]);
        if (getThrowawayClassLoaderMethod == null && log.isDebugEnabled()) {
            log.debug("The ClassLoader [{}] does NOT provide a 'getThrowawayClassLoader()' method; SimpleThrowawayClassLoader will be used instead.", (Object)classLoader.getClass().getName());
        }
        this.getThrowawayClassLoaderMethod = getThrowawayClassLoaderMethod;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"Transformer must not be null");
        ReflectionUtils.invokeMethod((Method)this.addTransformerMethod, (Object)this.classLoader, (Object[])new Object[]{transformer});
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        if (this.getThrowawayClassLoaderMethod != null) {
            ClassLoader target = (ClassLoader)ReflectionUtils.invokeMethod((Method)this.getThrowawayClassLoaderMethod, (Object)this.classLoader);
            return target instanceof DecoratingClassLoader ? target : new OverridingClassLoader(this.classLoader, target);
        }
        return new SimpleThrowawayClassLoader(this.classLoader);
    }
}

