/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.instrument;

import cn.taketoday.instrument.InstrumentationSavingAgent;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.instrument.SimpleThrowawayClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;

public class InstrumentationLoadTimeWeaver
implements LoadTimeWeaver {
    private static final boolean AGENT_CLASS_PRESENT = ClassUtils.isPresent((String)"cn.taketoday.instrument.InstrumentationSavingAgent", (ClassLoader)InstrumentationLoadTimeWeaver.class.getClassLoader());
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Instrumentation instrumentation;
    private final ArrayList<ClassFileTransformer> transformers = new ArrayList(4);

    public InstrumentationLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public InstrumentationLoadTimeWeaver(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.instrumentation = InstrumentationLoadTimeWeaver.getInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"Transformer must not be null");
        FilteringClassFileTransformer actualTransformer = new FilteringClassFileTransformer(transformer, this.classLoader);
        ArrayList<ClassFileTransformer> arrayList = this.transformers;
        synchronized (arrayList) {
            Assert.state((this.instrumentation != null ? 1 : 0) != 0, (String)"Must start with Java agent to use InstrumentationLoadTimeWeaver.");
            this.instrumentation.addTransformer(actualTransformer);
            this.transformers.add(actualTransformer);
        }
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        Assert.state((this.classLoader != null ? 1 : 0) != 0, (String)"No ClassLoader available");
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransformers() {
        ArrayList<ClassFileTransformer> arrayList = this.transformers;
        synchronized (arrayList) {
            if (this.instrumentation != null && !this.transformers.isEmpty()) {
                for (int i = this.transformers.size() - 1; i >= 0; --i) {
                    this.instrumentation.removeTransformer(this.transformers.get(i));
                }
                this.transformers.clear();
            }
        }
    }

    public static boolean isInstrumentationAvailable() {
        return InstrumentationLoadTimeWeaver.getInstrumentation() != null;
    }

    @Nullable
    private static Instrumentation getInstrumentation() {
        if (AGENT_CLASS_PRESENT) {
            return InstrumentationAccessor.getInstrumentation();
        }
        return null;
    }

    private record FilteringClassFileTransformer(ClassFileTransformer targetTransformer, @Nullable ClassLoader targetClassLoader) implements ClassFileTransformer
    {
        @Override
        @Nullable
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (this.targetClassLoader != loader) {
                return null;
            }
            return this.targetTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }

        @Override
        public String toString() {
            return "FilteringClassFileTransformer for: " + this.targetTransformer;
        }
    }

    private static class InstrumentationAccessor {
        private InstrumentationAccessor() {
        }

        public static Instrumentation getInstrumentation() {
            return InstrumentationSavingAgent.getInstrumentation();
        }
    }
}

