/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.format.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.format.annotation.PeriodFormat;
import cn.taketoday.format.annotation.PeriodStyle;
import cn.taketoday.format.annotation.PeriodUnit;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;

final class StringToPeriodConverter
implements GenericConverter {
    StringToPeriodConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Period.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        return this.convert(source.toString(), this.getStyle(targetType), this.getPeriodUnit(targetType));
    }

    @Nullable
    private PeriodStyle getStyle(TypeDescriptor targetType) {
        PeriodFormat annotation = (PeriodFormat)targetType.getAnnotation(PeriodFormat.class);
        return annotation != null ? annotation.value() : null;
    }

    @Nullable
    private ChronoUnit getPeriodUnit(TypeDescriptor targetType) {
        PeriodUnit annotation = (PeriodUnit)targetType.getAnnotation(PeriodUnit.class);
        return annotation != null ? annotation.value() : null;
    }

    private Period convert(String source, @Nullable PeriodStyle style, @Nullable ChronoUnit unit) {
        style = style != null ? style : PeriodStyle.detect(source);
        return style.parse(source, unit);
    }
}

